package org.nuiton.jaxx.widgets.config;

/*-
 * #%L
 * JAXX :: Widgets Config
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.config.model.ConfigUIModel;
import static io.ultreia.java4all.i18n.I18n.t;

public class ConfigUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UTU9TQRS9LW2BFr9KgisTDCgaZCpuNMH4BRIhRYjUhNiN0/fGMmT6Znhvnn3EyMKFO/+AC7duDP+BuDJx45b/YMJP8M68Rz+kBbRJ57XTc8+ce+ecfvsN2cCHW9KvEy/kWnpki0YR8UNP8wYjy483NlZrW8zRCyxwfK609CF+pdKQrkLBbe0HGki1jEylmKlkmEoJU2leNpT0mNdBNFeGfKB3BAs2GdMabvQtdoKgtN5CzkUq9JOzeqruddbPj7MHKbbwOQ0QKZRv2p7+B4J215kypLmroVjeom9pSVCvjuJ87tWxoXNmb17QIHhOG2wbdmGwDDlFfSTTMPNf47F0lipSGoYml9eox8RtDVN/629yt850QBzpveF1bMM8Xi4pZctzGrIN6TKh4c4plRbWql8x39okeYdqVpc+Z3jll03DEQma2D9ZrtBajblGn8EOt0qORM/i2LoK7G43NrONujSMduGehBq1GkRR4c1d73dz6BTSdkr70lJVyPqhMIon+pvU+OwFomKHTfR3mDnGAj/s7fpfm4cHnbYaP62qI0F4x8qXivnaTvNC7KlQc1FaoWquCsMBExg/G6+pk5WvJ0hUjyouGSZimMgzGmwiW3bwYP/72OtfA5BehLyQ1F2kBr8Ew3rTx4lJ4Ubq4SMrbqQ5hOtFfA/gjSOOS28J3aGhEHtkJr6mjGYRPoqJcWIgiX8raClFhauKhYwdhxDNVYSTnjp50q3G9lYPf3z5dG3/aNop7HPyLJXtiWdfQY57gnvMxjhJaM/YFlTAQle249crkJAYViX5uGLXq8emmNIwomltTVCHNeyfQfFdR1xI+eli5X0UmuKbtjPzaRq60naGM3KC7kjMCpy/71JNx2vcczFAD44xp8yaP5XRbN81y73eDKNn0JThThzdPhxjyPEHf6PwsIkGAAA=";
    private static final Logger log = LogManager.getLogger(ConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTabbedPane categories;
    protected ConfigUIHandler handler;
    protected ConfigUIModel model;
    protected JButton quit;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigUI $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(String defaultCategory) {
        getHandler().initUI(defaultCategory);
    }
    
    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        getHandler().destroy();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigUI() {
        $initialize();
    }

    public ConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__categories(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeCategory(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTabbedPane getCategories() {
        return categories;
    }

    public ConfigUIHandler getHandler() {
        return handler;
    }

    public ConfigUIModel getModel() {
        return model;
    }

    public JButton getQuit() {
        return quit;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCategories() {
        $objectMap.put("categories", categories = new JTabbedPane());
        
        categories.setName("categories");
        categories.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__categories"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createQuit() {
        $objectMap.put("quit", quit = new JButton());
        
        quit.setName("quit");
        quit.setText(t("config.action.quit"));
        quit.setToolTipText(t("config.action.quit.tip"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        handler = new ConfigUIHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createCategories();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createQuit();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(categories, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        // inline complete setup of $JPanel1
        $JPanel1.add(quit);
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 property setters
        categories.setTabPlacement(JTabbedPane.LEFT);
        quit.setIcon(SwingUtil.getUIManagerActionIcon("config-quit"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
