/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.config.model;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.ultreia.java4all.config.ApplicationConfig;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.widgets.config.model.CallBackFinalizer;
import org.nuiton.jaxx.widgets.config.model.CallBackMap;
import org.nuiton.jaxx.widgets.config.model.CallBacksManager;
import org.nuiton.jaxx.widgets.config.model.CategoryModel;
import org.nuiton.jaxx.widgets.config.model.OptionModel;

public class ConfigUIModel
implements Iterable<CategoryModel> {
    private static final Logger log = LogManager.getLogger(ConfigUIModel.class);
    public static final String CATEGORY_MODEL_PROPERTY_NAME = "categoryModel";
    protected final Map<String, CategoryModel> categories;
    protected final File configFile;
    protected final Object configBean;
    protected final ApplicationConfig applicationConfig;
    protected CategoryModel categoryModel;
    protected boolean saved;
    protected boolean standalone;
    protected final CallBacksManager callBacksManager;
    protected Runnable closeAction;
    protected final PropertyChangeSupport pcs;

    public ConfigUIModel(Object configBean, ApplicationConfig applicationConfig, File configFile) {
        this.configBean = configBean;
        this.applicationConfig = applicationConfig;
        this.configFile = configFile;
        this.categories = new LinkedHashMap<String, CategoryModel>();
        this.callBacksManager = new CallBacksManager();
        this.pcs = new PropertyChangeSupport(this);
    }

    @Deprecated
    public ConfigUIModel(Supplier<ApplicationConfig> config) {
        this(config, (ApplicationConfig)config.get(), ((ApplicationConfig)config.get()).getUserConfigFile());
    }

    @Deprecated
    public ConfigUIModel(Object configBean, ApplicationConfig applicationConfig) {
        this(configBean, applicationConfig, applicationConfig.getUserConfigFile());
    }

    @Deprecated
    public ConfigUIModel(Supplier<ApplicationConfig> config, File configFile) {
        this(config, (ApplicationConfig)config.get(), configFile);
    }

    @Deprecated
    public ConfigUIModel(ApplicationConfig applicationConfig) {
        this(applicationConfig, applicationConfig, applicationConfig.getUserConfigFile());
    }

    @Deprecated
    public ConfigUIModel(ApplicationConfig applicationConfig, File configFile) {
        this(applicationConfig, applicationConfig, configFile);
    }

    public void addCategory(CategoryModel category) {
        if (this.categories.containsKey(category.getCategory())) {
            throw new IllegalArgumentException(I18n.t((String)"config.error.category.already.exists", (Object[])new Object[]{category.getCategory()}));
        }
        this.categories.put(category.getCategory(), category);
    }

    public void setCategory(String category) {
        if (!this.categories.containsKey(category)) {
            throw new IllegalArgumentException(I18n.t((String)"config.error.category.not.found", (Object[])new Object[]{category}));
        }
        CategoryModel newCategoryModel = this.categories.get(category);
        this.setCategoryModel(newCategoryModel);
        newCategoryModel.firePropertyChange("modified", false, this.getCategoryModel().isModified());
        newCategoryModel.firePropertyChange("valid", false, this.getCategoryModel().isValid());
    }

    public void registerCallBack(String name, String description, Icon icon, Runnable action) {
        this.callBacksManager.registerCallBack(name, description, icon, action);
    }

    public void registerOptionCallBack(String name, OptionModel option) {
        this.callBacksManager.registerOption(name, option);
    }

    public void setFinalizer(CallBackFinalizer finalizer) {
        this.callBacksManager.setFinalizer(finalizer);
    }

    public Runnable getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(Runnable closeAction) {
        this.closeAction = closeAction;
    }

    public CallBackMap getCallBacksForSaved() {
        return this.callBacksManager.getCallBacksForSaved(this);
    }

    @Override
    public Iterator<CategoryModel> iterator() {
        return this.categories.values().iterator();
    }

    public CategoryModel getCategoryModel() {
        return this.categoryModel;
    }

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel old = this.categoryModel;
        this.categoryModel = categoryModel;
        this.firePropertyChange(CATEGORY_MODEL_PROPERTY_NAME, old, categoryModel);
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void saveModified() {
        block13: {
            ArrayList<String> transients = new ArrayList<String>();
            for (OptionModel option : this.categoryModel) {
                if (option.isModified()) {
                    Object value = option.getValue();
                    if (option.getPropertyName() != null) {
                        try {
                            PropertyUtils.setProperty((Object)this.configBean, (String)option.getPropertyName(), (Object)value);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("could not set property [" + option.getPropertyName() + "] with value = " + value, e);
                        }
                    } else {
                        String toSave;
                        if (value == null) {
                            toSave = null;
                        } else if (option.isArrayType()) {
                            int length = Array.getLength(value);
                            ArrayList values = Lists.newArrayListWithCapacity((int)length);
                            for (int i = 0; i < length; ++i) {
                                values.add(Array.get(value, i));
                            }
                            toSave = Joiner.on((String)",").join((Iterable)values);
                        } else {
                            toSave = value.toString();
                        }
                        this.applicationConfig.setOption(option.getKey(), toSave);
                    }
                    option.setSaved(true);
                    option.initValue(value);
                }
                if (!option.isTransient()) continue;
                transients.add(option.getKey());
            }
            this.setSaved(true);
            try {
                this.applicationConfig.save(this.configFile, false, transients.toArray(new String[transients.size()]));
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block13;
                log.warn(I18n.t((String)"config.error.applicationconfig.save", (Object[])new Object[]{this.configFile}), (Throwable)eee);
            }
        }
        this.categoryModel.firePropertyChange("modified", this.categoryModel.isModified(), true);
        this.categoryModel.firePropertyChange("valid", false, this.categoryModel.isValid());
        this.categoryModel.firePropertyChange("reload", false, true);
    }

    public void reset() {
        for (OptionModel key : this.categoryModel) {
            if (!key.isModified()) continue;
            key.initValue(key.getOriginalValue());
        }
        this.categoryModel.firePropertyChange("modified", this.categoryModel.isModified(), true);
        this.categoryModel.firePropertyChange("valid", false, this.categoryModel.isValid());
        this.categoryModel.firePropertyChange("reload", false, true);
    }

    public int getCategoryIndex(String category) {
        int i = 0;
        for (CategoryModel m : this) {
            if (category.equals(m.getCategory())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void destroy() {
        JAXXUtil.destroy((PropertyChangeSupport)this.pcs);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    protected ApplicationConfig getConfig() {
        return this.applicationConfig;
    }

    protected ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    protected CallBacksManager getCallBacksManager() {
        return this.callBacksManager;
    }

    public String getCategoryName(int index) {
        return (String)Lists.newArrayList(this.categories.keySet()).get(index);
    }
}

