/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.config;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.context.JAXXInitialContext;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.config.ConfigCallBackUI;
import org.nuiton.jaxx.widgets.config.ConfigCallBackUIHandler;
import org.nuiton.jaxx.widgets.config.ConfigCategoryUI;
import org.nuiton.jaxx.widgets.config.ConfigUI;
import org.nuiton.jaxx.widgets.config.model.CallBackMap;
import org.nuiton.jaxx.widgets.config.model.CategoryModel;
import org.nuiton.jaxx.widgets.config.model.ConfigUIModel;
import org.nuiton.jaxx.widgets.config.model.OptionModel;

public class ConfigUIHandler
implements UIHandler<ConfigUI> {
    public static final Logger log = LogManager.getLogger(ConfigUIHandler.class);
    static final String CALLBACKS_WITH_OPTIONS = "callbacksWithOptions";
    static final String CALLBACKS = "callbacks";
    private static final String QUIT_ACTION = "quit";
    private ConfigUI ui;
    private Container topContainer;
    private ConfigCallBackUICustomizer configCallBackUICustomizer;
    private ChangeCategoryCallBack changeCategoryCallBack;

    public void beforeInit(ConfigUI ui) {
        this.ui = ui;
    }

    public void afterInit(ConfigUI ui) {
    }

    public void setChangeCategoryCallBack(ChangeCategoryCallBack changeCategoryCallBack) {
        this.changeCategoryCallBack = changeCategoryCallBack;
    }

    void initUI(String defaultCategory) {
        ConfigUIModel model = this.ui.getModel();
        JTabbedPane categories = this.ui.getCategories();
        categories.setModel(new DefaultSingleSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                boolean canContinue;
                boolean bl = canContinue = !this.isSelected() || ConfigUIHandler.this.canQuitCategory();
                if (canContinue) {
                    if (log.isDebugEnabled()) {
                        log.debug("new index : " + index);
                    }
                    String categoryName = ConfigUIHandler.this.ui.getModel().getCategoryName(index);
                    if (ConfigUIHandler.this.changeCategoryCallBack == null || ConfigUIHandler.this.changeCategoryCallBack.canChangeCategory(categoryName)) {
                        super.setSelectedIndex(index);
                    }
                }
            }
        });
        JButton quitButton = this.ui.getQuit();
        Action quitAction = this.createQuitAction();
        String tip = quitButton.getToolTipText();
        quitButton.setAction(quitAction);
        quitButton.setToolTipText(tip);
        for (CategoryModel categoryModel : model) {
            String category = categoryModel.getCategory();
            String categoryLabel = I18n.t((String)categoryModel.getCategoryLabel(), (Object[])new Object[0]);
            ConfigCategoryUI p = new ConfigCategoryUI((JAXXContext)new JAXXInitialContext().add((Object)this.ui).add((Object)categoryModel));
            p.getCategoryLabel().setText(categoryLabel);
            p.setName(category);
            categories.addTab(I18n.t((String)category, (Object[])new Object[0]), null, p, categoryLabel);
        }
        model.setCategory(defaultCategory);
        int categoryIndex = model.getCategoryIndex(defaultCategory);
        if (log.isDebugEnabled()) {
            log.debug("index of default category (" + defaultCategory + ")  : " + categoryIndex);
        }
        categories.setSelectedIndex(categoryIndex);
    }

    void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("destroy ui " + this.ui.getName());
        }
        JAXXUtil.destroy((Component)this.ui);
        this.ui.getModel().destroy();
    }

    void changeCategory(ChangeEvent e) {
        JPanel p = (JPanel)this.ui.getCategories().getSelectedComponent();
        if (p == null) {
            return;
        }
        this.ui.getModel().setCategory(p.getName());
        this.ui.getCategories().invalidate();
    }

    void displayUI(Frame parentUI, boolean undecorated) {
        JDialog f = new JDialog(parentUI, true);
        f.setTitle(I18n.t((String)"config.title", (Object[])new Object[0]));
        f.add(this.ui);
        if (parentUI != null) {
            f.setIconImage(parentUI.getIconImage());
        }
        this.ui.getModel().setStandalone(parentUI == null);
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ActionEvent myEvent = new ActionEvent(e.getSource(), 1, ConfigUIHandler.QUIT_ACTION);
                ConfigUIHandler.this.ui.getQuit().getAction().actionPerformed(myEvent);
            }
        });
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(this.ui.getQuit());
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), QUIT_ACTION);
        rootPane.getActionMap().put(QUIT_ACTION, this.ui.getQuit().getAction());
        f.pack();
        SwingUtil.center((Component)parentUI, (Component)f);
        f.setVisible(true);
    }

    private Action createQuitAction() {
        JButton button = this.ui.getQuit();
        return new AbstractAction(button.getText(), button.getIcon()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Container parentContainer;
                Window parentWindow;
                if (!ConfigUIHandler.this.canQuitCategory()) {
                    return;
                }
                if (ConfigUIHandler.this.topContainer == null) {
                    parentWindow = ConfigUIHandler.this.ui.getParentContainer(Window.class);
                    parentContainer = parentWindow;
                } else {
                    parentWindow = null;
                    parentContainer = ConfigUIHandler.this.topContainer;
                }
                ConfigUIModel model = ConfigUIHandler.this.ui.getModel();
                if (!model.isSaved() || model.isStandalone()) {
                    ConfigUIHandler.this.closeUI(parentWindow, model);
                    return;
                }
                CallBackMap forSaved = model.getCallBacksForSaved();
                if (forSaved.isEmpty()) {
                    ConfigUIHandler.this.closeUI(parentWindow, model);
                    return;
                }
                forSaved = model.getCallBacksForSaved();
                JAXXInitialContext context = new JAXXInitialContext().add((Object)ConfigUIHandler.this.ui).add(ConfigUIHandler.CALLBACKS_WITH_OPTIONS, (Object)forSaved).add(ConfigUIHandler.CALLBACKS, new ArrayList(forSaved.keySet())).add((Object)new ConfigCallBackUIHandler());
                if (ConfigUIHandler.this.topContainer == null) {
                    context.add("parent", (Object)parentWindow);
                }
                ConfigCallBackUI lastUI = new ConfigCallBackUI((JAXXContext)context);
                lastUI.init();
                if (ConfigUIHandler.this.configCallBackUICustomizer != null) {
                    ConfigUIHandler.this.configCallBackUICustomizer.customize(lastUI);
                }
                ConfigUIHandler.this.ui.setVisible(false);
                parentContainer.remove(ConfigUIHandler.this.ui);
                parentContainer.add(lastUI);
                SwingUtilities.invokeLater(parentContainer::validate);
            }
        };
    }

    public void setConfigCallBackUICustomizer(ConfigCallBackUICustomizer configCallBackUICustomizer) {
        this.configCallBackUICustomizer = configCallBackUICustomizer;
    }

    private void closeUI(Window parentWindow, ConfigUIModel model) {
        Runnable runnable;
        this.destroy();
        if (parentWindow != null) {
            parentWindow.dispose();
        }
        if ((runnable = model.getCloseAction()) != null) {
            log.info("execute close action");
            runnable.run();
        }
    }

    private boolean canQuitCategory() {
        boolean canContinue = true;
        ConfigUIModel model = this.ui.getModel();
        CategoryModel categoryModel = model.getCategoryModel();
        String categoryName = I18n.t((String)categoryModel.getCategory(), (Object[])new Object[0]);
        if (!categoryModel.isValid()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(I18n.t((String)"config.message.quit.invalid.category", (Object[])new Object[]{categoryName}));
            buffer.append('\n');
            for (OptionModel m : categoryModel.getInvalidOptions()) {
                buffer.append("\n- ").append(m.getKey());
            }
            buffer.append('\n');
            int reponse = this.askUser(I18n.t((String)"config.title.need.confirm", (Object[])new Object[0]), buffer.toString(), 0, new Object[]{I18n.t((String)"config.choice.continue", (Object[])new Object[0]), I18n.t((String)"config.choice.cancel", (Object[])new Object[0])}, 0);
            switch (reponse) {
                case -1: 
                case 1: {
                    canContinue = false;
                    break;
                }
                case 0: {
                    if (!categoryModel.isModified()) break;
                    model.reset();
                }
            }
        } else if (categoryModel.isModified()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(I18n.t((String)"config.message.quit.valid.and.modified.category", (Object[])new Object[]{categoryName})).append('\n');
            for (OptionModel m : categoryModel.getModifiedOptions()) {
                buffer.append("\n- ").append(m.getKey());
            }
            buffer.append('\n');
            int reponse = this.askUser(I18n.t((String)"config.title.need.confirm", (Object[])new Object[0]), buffer.toString(), 2, new Object[]{I18n.t((String)"config.choice.save", (Object[])new Object[0]), I18n.t((String)"config.choice.doNotSave", (Object[])new Object[0]), I18n.t((String)"config.choice.cancel", (Object[])new Object[0])}, 0);
            switch (reponse) {
                case -1: 
                case 2: {
                    canContinue = false;
                    break;
                }
                case 0: {
                    model.saveModified();
                    break;
                }
                case 1: {
                    model.reset();
                }
            }
        }
        return canContinue;
    }

    private int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        return JOptionPane.showOptionDialog(this.ui, message, title, -1, typeMessage, null, options, options[defaultOption]);
    }

    public void setTopContainer(Container topContainer) {
        this.topContainer = topContainer;
    }

    public static interface ConfigCallBackUICustomizer {
        public void customize(ConfigCallBackUI var1);
    }

    public static interface ChangeCategoryCallBack {
        public boolean canChangeCategory(String var1);
    }
}

