package org.nuiton.jaxx.widgets.config;

/*-
 * #%L
 * JAXX :: Widgets Config
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import static org.nuiton.i18n.I18n.t;

public class ConfigCallBackUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUQU8TQRTHp5W2tBWpkKAHDySgGJFdvegBggqEFKxiBAmxF6e7Yzs43Rln39rlwsGDN7+AB69eDN+BeDLx4pXvYMJH8M1uaalpa4EedjbT937zf2/+b7//ISlfk7tSVy0v4CA9a5eGoaUDD3idWetPdnY2KrvMgRXmO5orkJrEv0SSJMsk77b2fSBWuYQkOybZhmQ3SfayrCvpMe8UaL5Ecj7sCebXGAMgt3smO75vb7Yi50MV6OZZXVV3O+vXp/tHCbbyJUlIqFB+BsuePQOgXfVQiSS5C2SstEs/UFtQr4riNPeqWNCI2VsW1Pef0zp7T/ZJpkTSimqEAZk7V3siXIQKFZDh6fUX1GPiHhD7X/0N7lYZ+JYjvbe8imWYZZkKsUSdd6/WlIowaSCZGvVcwTSQB2dkFOPENmpken3T0VIIowpFXTMdCC2/gQ2xTv1lwrOtrILLAF3F3BMykKsdiVuaRSmjrZRkVQIZ7whaCgB1d5JzgJlFRl1T3VhHeNS3zmjsZolWom52xka7Jui6Qqfc6uUUdKbVdmbbJIkySekAt4FM9R4K4+uXGBU7eqq3o80xUeDHg339rXF8dGLjLIqb/F/WqYlFTyktFfaGG22jsYcD4MJ+RtV8GYFM4MVE4zzTX/lmMxLVo4ro+ixDsorUryEtlTk6/DHx5vclklwlOSGpu0pN/BrJQk1jx6RwQ/XocSTucmMYnwUjE0ha0D2Jd0uuLLgU6GSFey7eymKIXZrp36WWqION459fP988POlUAjVOD5LZ7lbqNUlzT3CPRSPfnOauI55XPgtc2R7VbsObMGtONWdnKnrOdKu/4EgR1L3YxducNUzknTAwy2xUi3mbi3iFAXjDzOVAKwIdOrYQVzRJAb9ZlQDYYnfu+ADcvJYStrnPEW2CHp4fldWyUWS8WoMLgoa4E38SevRrYhAGsLCfjkEYeZBSbHG1dVGU2X7ah3ADCX8BJd69h8gHAAA=";
    private static final Log log = LogFactory.getLog(ConfigCallBackUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTree detectedCallBack;
    protected JButton go;
    protected ConfigCallBackUIHandler handler;
    protected JPanel treeHeader;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private ConfigCallBackUI $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
         * Init the ui.
         */
        public void init() {
            getHandler().init(this);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCallBackUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI() {
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__go(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().doAction(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTree getDetectedCallBack() {
        return detectedCallBack;
    }

    public JButton getGo() {
        return go;
    }

    public ConfigCallBackUIHandler getHandler() {
        return handler;
    }

    public JPanel getTreeHeader() {
        return treeHeader;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTreeHeader() {
        treeHeader.add($JLabel0);
    }

    protected void createDetectedCallBack() {
        $objectMap.put("detectedCallBack", detectedCallBack = new JTree());
        
        detectedCallBack.setName("detectedCallBack");
        detectedCallBack.setEditable(false);
        detectedCallBack.setRootVisible(false);
        detectedCallBack.setRowHeight(24);
    }

    protected void createGo() {
        $objectMap.put("go", go = new JButton());
        
        go.setName("go");
        go.setText(t("config.launch.callBack"));
        go.setToolTipText(t("config.launch.callBack.tip"));
        go.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__go"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ConfigCallBackUIHandler.class));
    }

    protected void createTreeHeader() {
        $objectMap.put("treeHeader", treeHeader = new JPanel());
        
        treeHeader.setName("treeHeader");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDetectedCallBack();
        createGo();
        createTreeHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("config.detected.callBack"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JScrollPane0, BorderLayout.CENTER);
        add(go, BorderLayout.SOUTH);
        add(treeHeader, BorderLayout.EAST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(detectedCallBack);
        addChildrenToTreeHeader();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 property setters
        $JScrollPane0.setColumnHeaderView(treeHeader);
        go.setIcon(SwingUtil.getUIManagerActionIcon("config-quit"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
