/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.config;

import java.awt.Component;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.config.ConfigCallBackUI;
import org.nuiton.jaxx.widgets.config.model.CallBackEntry;
import org.nuiton.jaxx.widgets.config.model.CallBackMap;
import org.nuiton.jaxx.widgets.config.model.OptionModel;

class ConfigCallBackUIHandler {
    private static final Log log = LogFactory.getLog(ConfigCallBackUIHandler.class);

    ConfigCallBackUIHandler() {
    }

    void init(ConfigCallBackUI ui) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        CallBackMap forSaved = ui.getContextValue(CallBackMap.class, "callbacksWithOptions");
        for (Map.Entry e : forSaved.entrySet()) {
            CallBackEntry callBackEntry = (CallBackEntry)e.getKey();
            List options = (List)e.getValue();
            DefaultMutableTreeNode callBackNode = new DefaultMutableTreeNode(callBackEntry, true);
            root.add(callBackNode);
            for (OptionModel o : options) {
                DefaultMutableTreeNode optionkNode = new DefaultMutableTreeNode(o, false);
                callBackNode.add(optionkNode);
            }
        }
        JTree tree = ui.getDetectedCallBack();
        tree.setModel(new DefaultTreeModel(root));
        SwingUtil.expandTree((JTree)tree);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object v;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("value = " + value.getClass()));
                }
                if (value == null) {
                    return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                }
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                }
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)value;
                if ((value = n.getUserObject()) instanceof CallBackEntry) {
                    v = (CallBackEntry)value;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("callBackEntry detected " + ((CallBackEntry)v).getName()));
                    }
                    value = I18n.t((String)((CallBackEntry)v).getDescription(), (Object[])new Object[0]);
                } else if (value instanceof OptionModel) {
                    v = (OptionModel)value;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("option detected " + ((OptionModel)v).getKey()));
                    }
                    value = ((OptionModel)v).getKey() + " (" + I18n.t((String)((OptionModel)v).getDescription(), (Object[])new Object[0]) + ")";
                }
                JLabel rendererComponent = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                value = n.getUserObject();
                if (value instanceof CallBackEntry) {
                    CallBackEntry v2 = (CallBackEntry)value;
                    rendererComponent.setIcon(v2.getIcon());
                }
                return rendererComponent;
            }
        });
    }

    void doAction(ConfigCallBackUI ui) {
        log.info((Object)"Launch callBacks...");
        Window parent = ui.getContextValue(Window.class, "parent");
        if (parent != null) {
            log.info((Object)"dispose parent window...");
            parent.dispose();
        }
        SwingUtilities.invokeLater(() -> {
            List callBacks = (List)JAXXUtil.newListContextEntryDef((String)"callbacks").getContextValue((JAXXContext)ui);
            for (CallBackEntry e : callBacks) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("launch callBack " + I18n.t((String)e.getDescription(), (Object[])new Object[0])));
                }
                e.getAction().run();
            }
        });
    }
}

