package io.ultreia.java4all.jaxx.widgets.combobox;

/*-
 * #%L
 * JAXX :: Widgets ComboBox
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.jaxx.widgets.combobox.actions.JaxxComboBoxDisplayDecoratorAction;
import io.ultreia.java4all.jaxx.widgets.combobox.actions.JaxxComboBoxResetAction;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.bean.BeanTypeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableComboBoxModel;
import static io.ultreia.java4all.i18n.I18n.t;

public class JaxxComboBox<O> extends Table implements BeanTypeAware<O>, BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBOBOX_EDITABLE = "combobox.editable";
    public static final String BINDING_COMBOBOX_ENABLED = "combobox.enabled";
    public static final String BINDING_COMBOBOX_FOCUSABLE = "combobox.focusable";
    public static final String BINDING_COMBOBOX_MAXIMUM_ROW_COUNT = "combobox.maximumRowCount";
    public static final String BINDING_COMBOBOX_SELECTED_ITEM = "combobox.selectedItem";
    public static final String BINDING_DISPLAY_DECORATOR_ENABLED = "displayDecorator.enabled";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";
    public static final String BINDING_TOOLBAR_RIGHT_VISIBLE = "toolbarRight.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WzXIbRRAeK5b8J9tJCOEflERxLIJXgaK42BWCbQxOyTglm1QKXxhpx9K4VjvLzqy1KZVz4MCNF+DAlQuVV4AUJ6q4cPU7UJVHoHt2pdHKq8ix48OW1dPz9dc9PV/P7/+RrPTJR8JvWG7AlXCtAxqGlh+4ireYdf+LR4+2awesrtaZrPvcU8In0d9YhmT2yIzds0tFrL0KIJUjpDIilWOk8ppoecJlbh/QcoVMS/XYYbLJmFJkcejmupTlnZ7ncugFfhwrlXVarH9++vh4jK3/kiEk9ID+JUj79ksAmKzHKyTDbUUuVw7oIS071G0AOZ+7DUhoFm1rDpXyG9piP5AnZKJCch71AUyRpTOVR8NpqNBTZKK4S2sOu6PIZ1xYgaN8xqmFYT+ljhPl0eZ2gylp1UWrJmoitO6DdQ1/rIrQ8zRYTpFcXbj7vKHIytmQ1vR2g5dtCZs5iiyfDW4Ldxu0Ce7aLGTQVkvDzkm2oeq6SVcDBatf+SLwDMKUFL7SNjRc6SPqCS+AWl5FdmEX5gEat5gbGMc57bgDMBVaw9QuJ3ZoI7q+YWqKMb8F7ELCs0ptLiKSGGFTsVZy3yTuWxdtF39/kFyLWTBoIwqNMci7t5DcNa139Si+m1zNF82+O2grJtdnlBBOjfoVtg+NeyURcBeWVqkON2Vq6jOJt/i1hGuUMrqUTKrd01fk9YRztxGSwPmYSZU3mgptt5PrF20uPYc+Xmd1EdfnrQG6jYbDDJNPPLj7C8N6CrTGMlpjrv3YHqQYONiPN4bLHCpVFbwijboxXKMwjHb88ekT/7f28+OuMM0BucKoXX0aDCrh+cJjvuLIbT5SpUBxp7xFveU9uAXMAQHXAn3rxcx3Yk9gDywuIZKFSNbXVDYBLTtx/Oyvq9//e4FkNsi0I6i9QdF/k0ypJpx/Uzh26H1+T5PLtyfhexFpQgsHkmHb7HJvl4XQJuPKD1gINbr14hr1KD3dfv73rz/ffNat0xgwLJ5mp6lV9juS467DXaYlPFbnVMme8SQLbGGkN02MiRGpruqs6O+9EyXIKDIbnQOzH1IngM56s6Pl0gJBrLJD5kuGOrNYOhpeLcRe17njfxukX+JGMYBDyNWEb0OjkA87BZe1C7tcOcxe1cZFtXi9xqhrIaClcOV6qVQ4SgsayecpUp6G7uDC3YQ5A1QRfgnhMR+d1ryJ6KBOpQUbkOBRUbMgXTUzDPorNMAn3+OzhGsxpbyhhNbsYXRYE5196kh2hEIdHyPITOfakCNMSySeDK8ugTmTgA2Do5fCnEkhsneTyHWwjZI5DO3CtBR6Q2pUEheg3aNme0C5qwNldQGhkodccnjAwBTrRO8Pi8udpmhXcX7o9p/aB2lRVDtF29LI9E+oU/CZ2hf1QPaDAhfmogHYFQ2XL22uYy+WCgsLBfgd+WhmeQ0ykFPqFdHTcBQtnG7do8AnAbZU7zh2+hZ08EkWM4O5mUb3yLzAFjp4v/FxtcEdxXx0SDyzVrbvxqU2VSl2+pLF3NNjmKLNdpLVmW/RkLeCVlW010SAD973ujwhn63k4rAW6z4OXkmLvZ1ssd4T4SXaLPH8OHeflYYSOkeznXgBnWIWjPNIQ1ZsKEGhBmMM3kp3T6CP4fedkXho/gM/f6YjvH9uhGuA8D91ogj/rg4AAA==";
    private static final Logger log = LogManager.getLogger(JaxxComboBox.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox<O> combobox;
    protected JaxxComboBoxConfig<O> config;
    protected JToggleButton displayDecorator;
    protected JaxxComboBoxHandler<O> handler;
    protected JAXXButtonGroup indexes;
    protected JaxxComboBoxModel<O> model;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected JButton reset;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected JToolBar toolbarLeft;
    protected JToolBar toolbarRight;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JaxxComboBox<O> $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EMPTY = "empty";
    
    
    public void init(JXPathDecorator<O> decorator, List<O> data) {
        handler.init(decorator, data);
    }
    
    @Override
    public Class<O> getBeanType() {
        return config.getBeanType();
    }
    
    @Override
    public void setBeanType(Class<O> beanType) {
        config.setBeanType(beanType);
    }
    
    @Override
    public Object getBean() {
        return model.getBean();
    }
    
    @Override
    public void setBean(Object bean) {
        model.setBean(bean);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }
    
    
    public void setFilterable(boolean filterable) {
        config.setFilterable(filterable);
    }
    
    public void setShowReset(boolean showReset) {
        config.setShowReset(showReset);
    }
    
    public void setShowDecorator(boolean showDecorator) {
        config.setShowDecorator(showDecorator);
    }
    
    public void setSortable(boolean sortable) {
        config.setSortable(sortable);
    }
    
    public void setEditable(boolean editable) {
        config.setEditable(editable);
    }
    
    public void setAutoFocus(boolean autoFocus) {
        config.setAutoFocus(autoFocus);
    }
    
    public void setEnterToSelectUniqueUniverse(boolean enterToSelectUniqueUniverse) {
        config.setEnterToSelectUniqueUniverse(enterToSelectUniqueUniverse);
    }
    
    public void setTabToSelect(boolean tabToSelect) {
        config.setTabToSelect(tabToSelect);
    }
    
    public void setProperty(String property) {
        config.setProperty(property);
    }
    
    public void setSelectedToolTipText(String selectedToolTipText) {
        config.setSelectedToolTipText(selectedToolTipText);
    }
    
    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        config.setNotSelectedToolTipText(notSelectedToolTipText);
    }
    
    public void setPopupTitleText(String popupTitleText) {
        config.setPopupTitleText(popupTitleText);
    }
    
    public void setI18nPrefix(String i18nPrefix) {
        config.setI18nPrefix(i18nPrefix);
    }
    
    public void setMaximumRowCount(int maximumRowCount) {
        config.setMaximumRowCount(maximumRowCount);
    }
    
    public void setInvalidComboEditorTextColor(Color invalidComboEditorTextColor) {
        config.setInvalidComboEditorTextColor(invalidComboEditorTextColor);
    }
    
    public void setData(java.util.List<O> data) {
        model.setData(data);
    }
    
    public void setSelectedItem(O selectedItem) {
        model.setSelectedItem(selectedItem);
    }
    
    public void setIndex(int index) {
        model.setIndex(index);
    }
    
    public boolean isEmpty() { return model.isEmpty(); }
    
    public void addItem(O item) { model.addItem(item); }
    
    public void addItems(Iterable<O> items) { model.addItems(items); }
    
    public void removeItem(O item) { model.removeItem(item); }
    
    public void removeItems(Iterable<O> items) { model.removeItems(items); }
    
    public void reset() { handler.reset(); }
    
    public JaxxFilterableComboBoxModel<O> getComboBoxModel() { return (JaxxFilterableComboBoxModel<O>) combobox.getModel(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JaxxComboBox() {
        $initialize();
    }

    public JaxxComboBox(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.focusCombo();
    }

    public void doFocusLost__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        hidePopup();
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDisplayDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDisplayDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox<O> getCombobox() {
        return combobox;
    }

    public JaxxComboBoxConfig<O> getConfig() {
        return config;
    }

    public JToggleButton getDisplayDecorator() {
        return displayDecorator;
    }

    public JaxxComboBoxHandler<O> getHandler() {
        return handler;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public JaxxComboBoxModel<O> getModel() {
        return model;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public JButton getReset() {
        return reset;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JToolBar getToolbarRight() {
        return toolbarRight;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void addChildrenToSortDown() {
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(reset);
    }

    protected void addChildrenToToolbarRight() {
        toolbarRight.add(displayDecorator);
    }

    protected void createCombobox() {
        $objectMap.put("combobox", combobox = new JComboBox<O>());
        
        combobox.setName("combobox");
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JaxxComboBoxConfig<O>());
    }

    protected void createDisplayDecorator() {
        $objectMap.put("displayDecorator", displayDecorator = new JToggleButton());
        
        displayDecorator.setName("displayDecorator");
        displayDecorator.setFocusable(false);
        displayDecorator.setFocusPainted(false);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new JaxxComboBoxModel<O>(config));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusable(false);
        reset.setFocusPainted(false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    protected void createToolbarRight() {
        $objectMap.put("toolbarRight", toolbarRight = new JToolBar());
        
        toolbarRight.setName("toolbarRight");
        toolbarRight.setBorderPainted(false);
        toolbarRight.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        handler = new JaxxComboBoxHandler<>();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createConfig();
        createModel();
        createIndexes();
        createSortGroup();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createToolbarLeft();
        createReset();
        createCombobox();
        createToolbarRight();
        createDisplayDecorator();
        // inline creation of $Table0
        setName("$Table0");
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$Table0"));
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$Table0"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reverseSort", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortGroup.setSelectedValue(model.getReverseSort());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reverseSort", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORT_UP_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reverseSort", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortUp.setSelected(!model.getReverseSort());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reverseSort", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORT_DOWN_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("reverseSort", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortDown.setSelected(model.getReverseSort());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("reverseSort", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("showReset", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    toolbarLeft.setVisible(config.isShowReset());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("showReset", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("editable", this);
                }
                addPropertyChangeListener("enabled", this);
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    reset.setEnabled(config.isEditable() && isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("editable", this);
                }
                removePropertyChangeListener("enabled", this);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    combobox.setSelectedItem(model.getSelectedItem());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBOBOX_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    combobox.setEditable(config.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBOBOX_FOCUSABLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (config != null) {
                    config.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    combobox.setFocusable(isEnabled() && config.isEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (config != null) {
                    config.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combobox.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBOBOX_MAXIMUM_ROW_COUNT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("maximumRowCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    combobox.setMaximumRowCount(config.getMaximumRowCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("maximumRowCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOOLBAR_RIGHT_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("showDecorator", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    toolbarRight.setVisible(config.isShowDecorator());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("showDecorator", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_DECORATOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("showDecorator", this);
                }
                addPropertyChangeListener("enabled", this);
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    displayDecorator.setEnabled(config.isShowDecorator() && isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("showDecorator", this);
                }
                removePropertyChangeListener("enabled", this);
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(toolbarLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(combobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(toolbarRight, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToToolbarLeft();
        addChildrenToToolbarRight();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 property setters
        popup.setBorder( new TitledBorder(t("bean.sort.title")) );
        popupSortLabel.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort"));
        sortUp.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        combobox.setModel(new JaxxFilterableComboBoxModel<O>());// late initializer
        
        JaxxComboBoxResetAction.init(this, reset, JaxxComboBoxResetAction.class);
        JaxxComboBoxDisplayDecoratorAction.init(this, displayDecorator, JaxxComboBoxDisplayDecoratorAction.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
