/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing.unified;

import io.ultreia.java4all.i18n.I18n;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.AbstractValidator;

public class UnifiedValidatorMessage
implements Comparable<UnifiedValidatorMessage>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final AbstractValidator<?> validator;
    protected final Object bean;
    protected final String field;
    protected final String message;
    protected final NuitonValidatorScope scope;
    protected final JComponent editor;
    protected final boolean simpleValidator;

    public UnifiedValidatorMessage(AbstractValidator<?> validator, Object bean, String field, String message, NuitonValidatorScope scope, JComponent editor) {
        this.field = field;
        this.bean = bean;
        this.validator = validator;
        this.message = message == null ? null : message.trim();
        this.scope = scope;
        this.simpleValidator = validator instanceof SwingValidator;
        this.editor = editor;
    }

    public AbstractValidator<?> getValidator() {
        return this.validator;
    }

    public String getField() {
        return this.field;
    }

    public NuitonValidatorScope getScope() {
        return this.scope;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getBean() {
        return this.bean;
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public boolean isSimpleValidator() {
        return this.simpleValidator;
    }

    @Override
    public int compareTo(UnifiedValidatorMessage o) {
        int result = this.getScope().compareTo((Enum)o.getScope());
        if (result == 0) {
            if (this.simpleValidator) {
                result = o.simpleValidator ? 0 : -1;
            } else if (o.simpleValidator) {
                result = 1;
            }
            if (result == 0 && (result = this.field.compareTo(o.field)) == 0) {
                result = this.message.compareTo(o.message);
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedValidatorMessage)) {
            return false;
        }
        UnifiedValidatorMessage that = (UnifiedValidatorMessage)o;
        return this.field.equals(that.field) && Objects.equals(this.bean, that.bean) && Objects.equals(this.message, that.message) && this.scope == that.scope;
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + (this.bean != null ? this.bean.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    public String toString() {
        String s = this.scope + " - " + (this.field == null ? this.message : this.field + "[" + this.getBean() + "] - " + this.message);
        if (this.editor != null) {
            s = this.editor.getName() + " : " + s;
        }
        return s;
    }

    public String getI18nError(String error) {
        String text;
        if (!error.contains("##")) {
            text = I18n.t((String)error, (Object[])new Object[0]);
        } else {
            StringTokenizer stk = new StringTokenizer(error, "##");
            String errorName = stk.nextToken();
            ArrayList<String> args = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                args.add(stk.nextToken());
            }
            text = I18n.t((String)errorName, (Object[])args.toArray());
        }
        return text;
    }
}

