/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.nuiton.jaxx.validator.swing.SwingValidatorUtil;
import org.nuiton.jaxx.validator.swing.ui.AbstractBeanValidatorUI;
import org.nuiton.validator.NuitonValidatorScope;

public class IconValidationUI
extends AbstractBeanValidatorUI {
    private static final long serialVersionUID = 1L;
    protected final EnumMap<NuitonValidatorScope, BufferedImage> icons = new EnumMap(NuitonValidatorScope.class);

    public IconValidationUI(String field) {
        this(Collections.singleton(field));
    }

    public IconValidationUI(Collection<String> fields) {
        super(fields);
        for (NuitonValidatorScope scope : NuitonValidatorScope.values()) {
            BufferedImage image = IconValidationUI.prepareIcon(SwingValidatorUtil.getColor(scope));
            this.icons.put(scope, image);
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);
        NuitonValidatorScope scope = this.getScope();
        if (scope != null) {
            BufferedImage icon = this.icons.get(scope);
            g2.drawImage((Image)icon, l.getWidth() - icon.getWidth() - 1, 0, null);
        }
    }

    protected static BufferedImage prepareIcon(Color color) {
        int width = 7;
        int height = 8;
        BufferedImage icon = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setColor(color);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.WHITE);
        g2.drawLine(0, 0, width, height);
        g2.drawLine(0, height, width, 0);
        g2.dispose();
        return icon;
    }
}

