/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing.tab;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import org.nuiton.jaxx.validator.JAXXValidator;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessage;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessageTableModel;
import org.nuiton.validator.NuitonValidatorScope;

public class JTabbedPaneValidator {
    public static final Icon ERROR_ICON = UIManager.getIcon("action.error");
    private static final Icon FATAL_ICON = UIManager.getIcon("action.fatal");
    private static final Icon WARNING_ICON = UIManager.getIcon("action.warning");
    private static final Icon INFO_ICON = UIManager.getIcon("action.info");
    private static final Map<NuitonValidatorScope, Icon> SCOPES_ICONS = ImmutableMap.builder().put((Object)NuitonValidatorScope.FATAL, (Object)FATAL_ICON).put((Object)NuitonValidatorScope.ERROR, (Object)ERROR_ICON).put((Object)NuitonValidatorScope.WARNING, (Object)WARNING_ICON).put((Object)NuitonValidatorScope.INFO, (Object)INFO_ICON).build();
    private static final Logger log = LogManager.getLogger(JTabbedPaneValidator.class);
    private final TableModelListener computeTabValidStateListener;
    private final Multimap<TabInfo, String> propertiesByTab;
    private final boolean fatal;
    private final boolean error;
    private final boolean warning;
    private final boolean info;

    private JTabbedPaneValidator(Multimap<TabInfo, String> propertiesByTab, EnumSet<NuitonValidatorScope> scopes) {
        this.propertiesByTab = propertiesByTab;
        this.fatal = scopes.contains(NuitonValidatorScope.FATAL);
        this.error = scopes.contains(NuitonValidatorScope.ERROR);
        this.warning = scopes.contains(NuitonValidatorScope.WARNING);
        this.info = scopes.contains(NuitonValidatorScope.INFO);
        this.computeTabValidStateListener = e -> {
            SwingValidatorMessageTableModel source = (SwingValidatorMessageTableModel)e.getSource();
            this.computeTabValidState(source);
        };
    }

    public static Builder builder(JAXXValidator ui, String tabbedPaneId) {
        return new Builder(Objects.requireNonNull(ui), Objects.requireNonNull(tabbedPaneId));
    }

    public void install(SwingValidatorMessageTableModel errorTableModel) {
        errorTableModel.removeTableModelListener(this.computeTabValidStateListener);
        errorTableModel.addTableModelListener(this.computeTabValidStateListener);
        this.computeTabValidState(errorTableModel);
    }

    public void uninstall(SwingValidatorMessageTableModel errorTableModel) {
        errorTableModel.removeTableModelListener(this.computeTabValidStateListener);
    }

    public void computeTabValidState(SwingValidatorMessageTableModel errorTableModel) {
        int rowCount = errorTableModel.getRowCount();
        ArrayListMultimap propertiesByScope = ArrayListMultimap.create();
        for (int i = 0; i < rowCount; ++i) {
            SwingValidatorMessage row = errorTableModel.getRow(i);
            propertiesByScope.put((Object)row.getScope(), (Object)row.getField());
        }
        for (Map.Entry entry : this.propertiesByTab.asMap().entrySet()) {
            TabInfo tab = (TabInfo)entry.getKey();
            Collection tabProperties = (Collection)entry.getValue();
            NuitonValidatorScope scope = null;
            if (this.fatal && propertiesByScope.get((Object)NuitonValidatorScope.FATAL).removeAll(tabProperties)) {
                scope = NuitonValidatorScope.FATAL;
            } else if (this.error && propertiesByScope.get((Object)NuitonValidatorScope.ERROR).removeAll(tabProperties)) {
                scope = NuitonValidatorScope.ERROR;
            } else if (this.warning && propertiesByScope.get((Object)NuitonValidatorScope.WARNING).removeAll(tabProperties)) {
                scope = NuitonValidatorScope.WARNING;
            } else if (this.info && propertiesByScope.get((Object)NuitonValidatorScope.INFO).removeAll(tabProperties)) {
                scope = NuitonValidatorScope.INFO;
            }
            this.changeTabStates(tab, scope);
        }
    }

    private void changeTabStates(TabInfo propertyName, NuitonValidatorScope scope) {
        propertyName.setIcon(SCOPES_ICONS.get(scope));
    }

    public static class Builder {
        private final JAXXValidator ui;
        private final String tabbedPaneId;
        private final EnumSet<NuitonValidatorScope> scopes;
        private Map<String, JAXXValidator> extraTabs;

        Builder(JAXXValidator ui, String tabbedPaneId) {
            this.ui = ui;
            this.tabbedPaneId = tabbedPaneId;
            this.scopes = EnumSet.noneOf(NuitonValidatorScope.class);
        }

        public Builder addScope(NuitonValidatorScope ... scope) {
            this.scopes.addAll(Arrays.asList(scope));
            return this;
        }

        public Builder addExtraTab(Map<String, JAXXValidator> extraTabs) {
            this.extraTabs = Objects.requireNonNull(extraTabs);
            return this;
        }

        public JTabbedPaneValidator build() {
            JAXXObject jui = (JAXXObject)this.ui;
            JTabbedPane tabbedPane = (JTabbedPane)Objects.requireNonNull(jui.getObjectById(this.tabbedPaneId));
            List tabs = jui.get$objectMap().values().stream().filter(o -> o instanceof TabInfo && this.tabbedPaneId.equals(((TabInfo)o).getContainerId())).map(o -> (TabInfo)o).collect(Collectors.toList());
            log.info(String.format("Detected %d form TabbedPane: %s", tabs.size(), this.tabbedPaneId));
            ImmutableMap.Builder tabComponentsBuilder = ImmutableMap.builder();
            ImmutableMap.Builder tabsBuilder = ImmutableMap.builder();
            for (TabInfo tab : tabs) {
                String tabId = tab.getId();
                Component tabComponent = tabbedPane.getComponentAt(tab.getTabIndex());
                tabComponentsBuilder.put((Object)tabId, (Object)tabComponent);
                tabsBuilder.put((Object)tabId, (Object)tab);
            }
            ImmutableMap tabMap = tabsBuilder.build();
            ImmutableMap tabComponents = tabComponentsBuilder.build();
            ArrayListMultimap propertiesByTab = ArrayListMultimap.create();
            for (String string : this.ui.getValidatorIds()) {
                SwingValidator<?> validator = this.ui.getValidator(string);
                Set effectiveFields = validator.getEffectiveFields();
                for (String effectiveField : effectiveFields) {
                    JComponent editor = validator.getFieldRepresentation(effectiveField);
                    if (editor == null) continue;
                    for (Map.Entry entry : tabComponents.entrySet()) {
                        if (!SwingUtilities.isDescendingFrom(editor, (Component)entry.getValue())) continue;
                        log.info(String.format("Found in tab: %s - editor: %s", entry.getKey(), effectiveField));
                        propertiesByTab.put(tabMap.get(entry.getKey()), (Object)effectiveField);
                    }
                }
            }
            if (this.extraTabs != null) {
                for (Map.Entry entry : this.extraTabs.entrySet()) {
                    String tabId = (String)entry.getKey();
                    TabInfo tabInfo = (TabInfo)tabMap.get((Object)tabId);
                    JAXXValidator extraUi = (JAXXValidator)entry.getValue();
                    for (String validatorId : extraUi.getValidatorIds()) {
                        SwingValidator<?> validator = extraUi.getValidator(validatorId);
                        Set effectiveFields = validator.getEffectiveFields();
                        for (String effectiveField : effectiveFields) {
                            log.info(String.format("Found in tab: %s - editor: %s", entry.getKey(), effectiveField));
                            JComponent editor = validator.getFieldRepresentation(effectiveField);
                            if (editor == null) continue;
                            propertiesByTab.put((Object)tabInfo, (Object)effectiveField);
                        }
                    }
                }
            }
            return new JTabbedPaneValidator((Multimap)propertiesByTab, this.scopes);
        }
    }
}

