package org.nuiton.jaxx.runtime.bean;

/*-
 * #%L
 * JAXX :: Runtime Spi
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.decorator.Decorator;

/**
 * Contract to add decorator on any bean to compute toString.
 * <p>
 * When Jaxx compiles, it will then try to set any available bean defined in a {@code beanScope} attribute on a ancestor component.
 * <p>
 * Created on 26/06/120.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3
 */
public interface BeanDecoratorAware {

    Decorator<?> decorator();

    void registerDecorator(Decorator<?> decorator);

    default String decorate() {
        Decorator<?> decorator = decorator();
        if (decorator == null) {
            return null;
        }
        return decorator.toString(this);
    }

}

