/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.spi.init;

import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.spi.init.ComponentInitializer;

public abstract class ComponentInitializerSupport<C>
implements ComponentInitializer<C> {
    private final Map<String, C> editorMap = new TreeMap<String, C>();
    private final Class<C> componentType;
    private JAXXObject ui;

    protected ComponentInitializerSupport(Class<C> componentType) {
        this.componentType = componentType;
    }

    @Override
    public boolean acceptComponent(Object component) {
        return this.componentType.isAssignableFrom(component.getClass());
    }

    @Override
    public boolean acceptUi(JAXXObject ui) {
        return true;
    }

    public void register(String name, C component) {
        this.editorMap.put(name, component);
    }

    public void register(JComponent component) {
        this.editorMap.put(component.getName(), component);
    }

    @Override
    public void start(JAXXObject ui) {
        this.ui = ui;
        this.editorMap.clear();
    }

    @Override
    public void reset() {
        this.editorMap.clear();
    }

    @Override
    public void end(JAXXObject ui) {
    }

    @Override
    public boolean isTouched() {
        return this.ui != null && !this.editorMap.isEmpty();
    }

    public Map<String, C> getEditorMap() {
        return this.editorMap;
    }
}

