package org.nuiton.jaxx.runtime.spi.init;

/*-
 * #%L
 * JAXX :: Runtime Spi
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuiton.jaxx.runtime.JAXXObject;

/**
 * Created by tchemit on 20/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class UIInitializerContext<U extends JAXXObject> {

    private final U ui;
    private final Set<String> doNotBlockComponentIds;

    private final Map<Class, UIComponentInitializer> initializerComponents;
    private final Set<Class> initializerComponentTypes;

    public UIInitializerContext(U ui, Collection<UIComponentInitializer> initializerList) {
        this.ui = ui;
        this.doNotBlockComponentIds = new HashSet<>();
        this.initializerComponents = Maps.uniqueIndex(initializerList, UIComponentInitializer::getComponentType);
        this.initializerComponentTypes = this.initializerComponents.keySet();
    }

    public U getUi() {
        return ui;
    }

    public String[] acceptedComponentNames() {
        return doNotBlockComponentIds.toArray(new String[doNotBlockComponentIds.size()]);
    }

    public Set<String> doNotBlockComponentIds() {
        return doNotBlockComponentIds;
    }

    public Map<Class, UIComponentInitializer> initializerComponents() {
        return initializerComponents;
    }

    public Set<Class> initializerComponentTypes() {
        return initializerComponentTypes;
    }
}
