package org.nuiton.jaxx.runtime.spi.init;

/*-
 * #%L
 * JAXX :: Runtime Spi
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.nuiton.jaxx.runtime.JAXXObject;

/**
 * Created by tchemit on 20/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class UIInitializerSupport<UI extends JAXXObject, I extends UIInitializerContext<UI>> {

    private final Map<Class, UIComponentInitializer<?, UI, I>> initializerComponents;
    private final Set<Class> initializerComponentTypes;

    public abstract I createContext(UI ui);

    public UIInitializerSupport(Collection<UIComponentInitializer<?, UI, I>> initializerComponents) {
        this.initializerComponents = Maps.uniqueIndex(initializerComponents, UIComponentInitializer::getComponentType);
        this.initializerComponentTypes = this.initializerComponents.keySet();
    }

    public void init(UI ui) {
        init(createContext(ui));
    }

    public void init(I context) {
        UI ui = context.getUi();
        ArrayListMultimap<Class, Object> objectsByType = ArrayListMultimap.create();

        for (Object o : ui.get$objectMap().values()) {
            if (o == null) {
                continue;
            }
            if (initializerComponentTypes.contains(o.getClass())) {
                objectsByType.put(o.getClass(), o);
            } else {
                for (UIComponentInitializer<?, UI, I> initializer : initializerComponents.values()) {
                    if (initializer.accept(o)) {
                        objectsByType.put(initializer.getComponentType(), o);
                        break;
                    }
                }
            }
        }

        for (Map.Entry<Class, Collection<Object>> entry : objectsByType.asMap().entrySet()) {
            Class key = entry.getKey();
            UIComponentInitializer<?, UI, I> initializer = initializerComponents.get(key);
            init0(context, initializer, (Collection) entry.getValue());
        }

        String[] acceptedComponentNames = context.acceptedComponentNames();
        if (acceptedComponentNames.length > 0) {
            initBlockLayerUI(context, acceptedComponentNames);
        }

        initEnd(context);
    }

    protected void initEnd(I context) {

    }

    protected void initBlockLayerUI(I context, String... doNotBlockComponentIds) {

    }

    private <O> void init0(I context, UIComponentInitializer<O, UI, I> initializerComponent, Collection<O> o) {
        for (O o1 : o) {
            initializerComponent.init(context, o1);
        }
    }

}
