package org.nuiton.jaxx.runtime.spi.init;

/*-
 * #%L
 * JAXX :: Runtime Spi
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXObject;

/**
 * Created by tchemit on 21/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class UIComponentInitializerSupport<O, UI extends JAXXObject, I extends UIInitializerContext<UI>> implements UIComponentInitializer<O, UI, I> {

    /** Logger. */
    protected final Log log = LogFactory.getLog(getClass());

    protected final Class<O> componentType;

    protected UIComponentInitializerSupport(Class<O> componentType) {
        this.componentType = componentType;
    }

    @Override
    public Class<O> getComponentType() {
        return componentType;
    }

}
