package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import static io.ultreia.java4all.i18n.I18n.t;

public class JTextAreaDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_UPPER_TEXT_AREA_TEXT = "upperTextArea.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUzU5TQRTHTyuF8qVAFKKJCQnVqsi9whaiEgjRpogRFsRunN47KYPTmXHuXLlsWLhw5wu4cOvG8A7ElYkbt7yDCY/gmekXYFsqdjFt5/7Pb/7n3HPm22/IRBoeSl3xRMyMFN4uSRJPx8KwKvUKy9vbG+VdGphVGgWaKSM11D6pNKRLMBw29yMDXqmIJL9G8i3Jr5P8FVlVUlBxCrRYhKHI7HMa7VBqDNzrGBxEkb/ZVC4mKtb1s9q6bnfWz4/zxym6+jkNkCi0n8W0Z/8B0Mq6rwhpFhqYKO6S98TnRFTQnGaiggmN2r0VTqLoBanSd3AAA0XoV0QjzMDcpcrjcA6VKAPDuVValS+JoPyRgYXzKYT40AsaNC/aQ19eYYsmZllTYkOVcrB+AwO5LVLmFDEznSpRi3cyGzTYjM3mCkVSdh4mbM5J4yi3a0UjTe1orrAZaMm5dY0BU2cCWo/ORmVN3bSBG2cCGslY3cRfhubt//EuBpzg+jlBrBTVp8FTdrmlsEvudqoNdqXX6spWg6RKkNExbmNdOw+E7elXqKp180znbrbHOOGHwwP9de/kuNHCg2hu+qKoU9OK/aS0xDwNs96u1fo3Noz760QtlhBIOY66G+V8d+ebdSW6RxfjluRZkveMRDtIywwcH32ffPPrCqTXYIhLEq4Rq38Og2ZHY8UkDxP15KkzN7KXxXXM2sT3yO1bXJPawNWlkBgyXWYixBf/OME65bvXqWnrcOPkx5dPd44atUqhy1wvka16ZV5DPxOcCeoGvj7LbQd8WEU0DmVrUNuNbsp+j6n6+M24Nd+uAn228XGslmqnTxODt0s5NhQrYINmXT7211zPzPGQRYqTfRquC7wDBAusdOGyQLs934Uw2RPhvl0etCfc/G8PFxMMDJVJ8LaiZSzCLl5u90DK0pCZxjXZwdHFnGZOXZz8AYXqeSS0BwAA";
    private static final Logger log = LogManager.getLogger(JTextAreaDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea textArea;
    protected JTextArea upperTextArea;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JTextAreaDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextAreaDemo() {
        
    }

    public JTextAreaDemo(JAXXContext param0) {
        super(param0);
    }

    public JTextAreaDemo(boolean param0) {
        super(param0);
    }

    public JTextAreaDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    public JTextAreaDemo(LayoutManager param0) {
        super(param0);
    }

    public JTextAreaDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JTextAreaDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JTextAreaDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getTextArea() {
        return textArea;
    }

    public JTextArea getUpperTextArea() {
        return upperTextArea;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createTextArea() {
        $objectMap.put("textArea", textArea = new JTextArea());
        
        textArea.setName("textArea");
        textArea.setColumns(15);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setText(t("Try typing some text here."));
    }

    protected void createUpperTextArea() {
        $objectMap.put("upperTextArea", upperTextArea = new JTextArea());
        
        upperTextArea.setName("upperTextArea");
        upperTextArea.setColumns(15);
        upperTextArea.setLineWrap(true);
        upperTextArea.setWrapStyleWord(true);
        upperTextArea.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Normal text:"));
        $JLabel0.setDisplayedMnemonic(78);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTextArea();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Upper case text:"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createUpperTextArea();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPPER_TEXT_AREA_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (textArea != null) {
                    $bindingSources.put("textArea.getDocument()", textArea.getDocument());
                    textArea.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    textArea.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JTextAreaDemo.this, BINDING_UPPER_TEXT_AREA_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (textArea != null && textArea.getText() != null) {
                    upperTextArea.setText(textArea.getText().toUpperCase());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (textArea != null) {
                    Document $target = (Document) $bindingSources.remove("textArea.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    textArea.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JTextAreaDemo.this, BINDING_UPPER_TEXT_AREA_TEXT));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(textArea);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(upperTextArea);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 3 property setters
        $JLabel0.setLabelFor(textArea);
        $JLabel1.setLabelFor(upperTextArea);
        upperTextArea.setBackground(null);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
