package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Item;
import org.nuiton.jaxx.runtime.swing.JAXXComboBox;
import org.nuiton.jaxx.runtime.swing.Table;
import static io.ultreia.java4all.i18n.I18n.n;
import static io.ultreia.java4all.i18n.I18n.t;

public class JComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_TEXT = "$JButton0.text";
    private static final String BINDING_$JBUTTON1_TEXT = "$JButton1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ2UzW7TQBDHJ6FJmiZAP0QRQkKBBooo2LSIA2pVoK0qGgWKKIeKXNjEq9aV413Wa2ouPXDgxgtw4MoF9R0qTkhcuOYdkPoIzK5jp4niJJCDnczO/OY/k535/gcynoC7TOwZrm9L5hoHJAgM4bvSblKj8nR3d7t+QBtyg3oNYXPJBISfVBrSNShYsd2TYNSqSDJDkqlIZptkrrMmZy51z4CWqzDhyQ8O9fYplRJuJwY3PM/ciT2XA+6Ldq6+qvvl+vVpsZWiG1/SAAFH+QUse+EfAJ2qx6qQti0J09UD8p6YDnH3UJyw3T0s6LyyrTvE816QJn0HR5CrQpYTgTAJ9/6rPRqnUQGXUChv0CZ7SVzq3Jew1FuChYdGI6IZ3iHqMiqIr7M1FqhQzjUsKyFXfk3qDkXMXFInwnjtpoLycex4uVIlda1hWtUcRKm0VTkVY9+iQkYSJNwZnEzduci5m5MvV9Z8iWGYdKYraWju9o4ULqrfUz1njVjNpS7QkMSadbn7MFvekrSJkm4Mrkt58Z4ozbvea12KrAJuJTFxJIzOSHRuZ6oGGeGjGf/U5GlUA/UKvcJRmkseJZVGO348PhLfDk9b0fzkUFxpWNSZVYGXmQvGqZC20nYxHB5f2o75nPDlGuQ96uCe0XtkfrDynbYnqkcVU4pkKJLxjHj7SMvkWic/Zt/+PgfpTZhwGLE2ifLfgrzcF9gx5lgBf/xEiysejuNzUsmUMCZpgHM6vWK7ju3SEpE42HVf0tUA+zQ/uE+xrOPt059fP988iXqVQpXlUSI7/cq8gWyoQW+b9iLpu10K3KO+xTpbot/eSKn3JG/ftAX9NPt1YJxatozGfSnw1euBrkF9e6g5M0M5yrwo4cKKRSQp1W3XwglY7U+bHY02QM+VkQiPBhCujtCZTJNZ4WZLKGQ4JC4kgXANCX8Bm3vUcpMHAAA=";
    private static final Logger log = LogManager.getLogger(JComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox comboBox;
    protected JAXXComboBox jaxxComboBox;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JComboBoxDemo $DemoPanel0;
    private Item $Item0;
    private Item $Item1;
    private Item $Item2;
    private JButton $JButton0;
    private JButton $JButton1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        jaxxComboBox.setSelectedIndex(0);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBoxDemo() {
        
    }

    public JComboBoxDemo(JAXXContext param0) {
        super(param0);
    }

    public JComboBoxDemo(boolean param0) {
        super(param0);
    }

    public JComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    public JComboBoxDemo(LayoutManager param0) {
        super(param0);
    }

    public JComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getComboBox() {
        return comboBox;
    }

    public JAXXComboBox getJaxxComboBox() {
        return jaxxComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Item get$Item0() {
        return $Item0;
    }

    protected Item get$Item1() {
        return $Item1;
    }

    protected Item get$Item2() {
        return $Item2;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToJaxxComboBox() {
        java.util.List<org.nuiton.jaxx.runtime.swing.Item> jaxxComboBox$items = new java.util.ArrayList<org.nuiton.jaxx.runtime.swing.Item>();
        jaxxComboBox$items.add($Item0);
        jaxxComboBox$items.add($Item1);
        jaxxComboBox$items.add($Item2);
        jaxxComboBox.setItems(jaxxComboBox$items);
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new JComboBox());
        
        comboBox.setName("comboBox");
        comboBox.setEditable(true);
    }

    protected void createJaxxComboBox() {
        $objectMap.put("jaxxComboBox", jaxxComboBox = new JAXXComboBox());
        
        jaxxComboBox.setName("jaxxComboBox");
        jaxxComboBox.setEditable(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Button label:"));
        createJaxxComboBox();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Button label:"));
        createComboBox();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        // inline creation of $Item0
        $objectMap.put("$Item0", $Item0 = new Item("$Item0", null, "<data binding has not been processed yet>", true));
        // inline creation of $Item1
        $objectMap.put("$Item1", $Item1 = new Item("$Item1", null, "<data binding has not been processed yet>", false));
        // inline creation of $Item2
        $objectMap.put("$Item2", $Item2 = new Item("$Item2", null, "<data binding has not been processed yet>", false));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (jaxxComboBox != null) {
                    $bindingSources.put("jaxxComboBox", jaxxComboBox);
                    jaxxComboBox.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (jaxxComboBox != null) {
                    $JButton0.setText(String.valueOf(jaxxComboBox.getSelectedItem()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (jaxxComboBox != null) {
                    JAXXComboBox $target = (JAXXComboBox) $bindingSources.remove("jaxxComboBox");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboBox != null) {
                    $bindingSources.put("comboBox", comboBox);
                    comboBox.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboBox != null) {
                    $JButton1.setText(comboBox.getSelectedItem()+"");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboBox != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("comboBox");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(jaxxComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToJaxxComboBox();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 4 property setters
        $Item0.setValue(t("OK"));
        $Item1.setValue(t("Cancel"));
        $Item2.setValue(t("Help"));
        comboBox.setModel(new  DefaultComboBoxModel(new Object[]{n("OK"),n("Cancel"),n("Help")}));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
