package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.select.BeanDoubleList;
import static io.ultreia.java4all.i18n.I18n.t;

public class BeanDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_LIST_FILTERABLE = "doubleList.filterable";
    public static final String BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT = "doubleList.highlightFilterText";
    public static final String BINDING_DOUBLE_LIST_SHOW_DECORATOR = "doubleList.showDecorator";
    public static final String BINDING_DOUBLE_LIST_SHOW_RESET = "doubleList.showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vy24TSRS9NjgPB0iGlzQbiEICtmbohh1SeAyOFQEyBJEsENlM2V2xK7Srmqpq3JEFCxbs+AEWbGcz4h8Qq5Fmwzb/MBKfwK3uTttuum0PIlJKVtW9p06de+/pv/+DkpLwu5Bti/tMC27tkyCwpM8161Lrwd2nT7ea+7Sl61S1JPO0kBD9FYpQ3IUFJ9lXGqzdBiLZEZJtkOwYyd4QXU9wyoeA1htQVvrApapDqdZQyU1uKWVvJ5HrgefL+K5M1ll3/fv2+mGB1t8XAQIP6c/js3/7HwCDVx9vQJE5Gk439slLYruEt5GcZLyNDzpp9jZcotQj0qUv4DXMNmDGIxLBNFz9IXlCuBAq8DQsrNZpVzwmnLrXNNxKP8HBQ6t1hBbtUQfPpVWjhNeF33RpgyltUDwvxJ3RMLu6Q/AAES/liaJ6+EQrDDNJ80nu6Zbge6ztS6KZ4CEz3DRCBHHSg3DThJ9Ispb2mKupNHA1X+NtGs6N5Gx0aOt5TQQmfjFJ+7XD2h0X//VmmL9DAx3lm4Czo8GLqiN6T6ii+SFnTEidtgSyFzI/LGK7xR+RVkfkhpWdRF+sdlrJHnPaVCtLURcnKlWPWB0Jl/MKgFNgDaZg0JCFXShJH7exePkDaGboCUZF03Mpf3rMNWHgm4+v5V+9r4dHI1NGcsuTsobcAfvXk8KjUjPDbTGaF18z135IvPVdnMFQiNA6roxnvh1HIntk8YtBsgySdY+oDqKVZg8/fT7/55djUNyEsiuIs0lM/H2Y1x2JignXCbw7f4TkTvTmcF0yNDXMNIV0kCPU+pz2lneYdqlTC/cqurJimIQz1cRqRdV1sVrxmA31/Uq1+ipAZa+MVzZ5yMetr/98eLf26UjdAr5rdZrMgcKlZzDDuMs4DS0pdptMC1rwFPUdMbCSLHOBzFn2YpdYC9fqdxoWNRzXOIUaLo8TazDuGuaiwlPHpEqfBr6BvhqqYH7ZkOEP0/Owx/HI8I8RQqU94qpMRvnWMz21tXHUEreaTqG0u03PojqJRWKI0zHJMtGfxGbEd6csVJZZT6JTQvNm12/wx5LusQDbLyGFH9MuziOeD7fwxX66Py2mtmNyleorDSdTQq70M1RKJ80P9cCFfqrA6eAzmb1c6ef26ShAlnRDH7BJihnvdMmBQGQ4ddMhmiw3GXfw2337O+SCWcsTEc22Z5YX2QhLU3CaM020c+DRMTgXEOcbLnrwpvsKAAA=";
    private static final Logger log = LogManager.getLogger(BeanDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected BeanDoubleList<People> doubleList;
    protected JCheckBox filterOnNachoButton;
    protected JCheckBox filterableButton;
    protected BeanDoubleListDemoHandler handler;
    protected JCheckBox highlightFilterTextButton;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanDoubleListDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDoubleListDemo() {
        
    }

    public BeanDoubleListDemo(JAXXContext param0) {
        super(param0);
    }

    public BeanDoubleListDemo(boolean param0) {
        super(param0);
    }

    public BeanDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    public BeanDoubleListDemo(LayoutManager param0) {
        super(param0);
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public BeanDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getFilterOnNachoButton() {
        return filterOnNachoButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(filterOnNachoButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new BeanDoubleList<People>());
        
        doubleList.setName("doubleList");
        doubleList.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createFilterOnNachoButton() {
        $objectMap.put("filterOnNachoButton", filterOnNachoButton = new JCheckBox());
        
        filterOnNachoButton.setName("filterOnNachoButton");
        filterOnNachoButton.setText(t("jaxxdemo.beandoublelistdemo.filterOnNacho"));
        filterOnNachoButton.setSelected(false);
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(t("jaxxdemo.beandoublelistdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
        highlightFilterTextButton.setText(t("jaxxdemo.beandoublelistdemo.highlightFilterText"));
        highlightFilterTextButton.setSelected(false);
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beandoublelistdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beandoublelistdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new BeanDoubleListDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createFilterOnNachoButton();
        createDoubleList();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    doubleList.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    doubleList.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleList.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (highlightFilterTextButton != null) {
                    $bindingSources.put("highlightFilterTextButton.getModel()", highlightFilterTextButton.getModel());
                    highlightFilterTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    highlightFilterTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (highlightFilterTextButton != null) {
                    doubleList.setHighlightFilterText(highlightFilterTextButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (highlightFilterTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("highlightFilterTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    highlightFilterTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 4 property setters
        doubleList.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beandoublelistdemo.configuration")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
