package org.nuiton.jaxx.demo.feature.nav.content;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import static io.ultreia.java4all.i18n.I18n.t;

public class ActorContentUI extends AbstractContentUI<People> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ICON = "$JLabel0.icon";
    private static final String BINDING_$JTEXT_PANE0_TEXT = "$JTextPane0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vy1ITQRTtRAiPgCAoSLmhJIIPmMjKBZQSeZSkolAGS0o2dmaapKnOdNtzBwYWLFy48wdcuHVj8Q+UK6vcuOUfrOITvD0JCegQIjGLJNV975lzzz0n+fqLtHuaTEpdtFyfg3StLRoElvZd4GVmZTPr6yuFLWbDAvNszRVITSqvWJzEN0jSqZ17QKyNHCKlK0hpg5SuIqXnZVlJl7mngGZypNuDXcG8EmMA5O65zbbnpfO1yplA+br6rEjWUc/68WH6KMYWPsUJCRTS78CxH/wDQH3qthyJcwfIQG6LbtO0oG4RyWnuFnGgXnM2L6jnvaBl9o7sk44cSSiqEQzI1KXkCeFCqEABGUxlCh5oasO8dAE7Xi0/BPLoz1EcVpbWJqPga2a5dNuyK9VWxkbsWqtSIXICSJtDgQJJRQJhLQfOPGuVSSVYvavLU4LDKnUZkCEze2B5OyiFlc2fXJjKrlpDbyqbt7UUwlwh8eGzTbUrU95X60qmsmssgGrPjTM9JxemdCD6OdPm8PpZyM5UNkcLTCDewBm88NQU3VTokfHzPIKetOqerNsjtkHatY/HQMbOj4Nx9Eusqnh57Hwvm8eEhe8P9vWXneOjEwP3I7nRi7pOZRXdpLRUTJs9AumruNcHLtLPqZrZwFUywexKkCcaM89XK5E9srhmkCyDZD2jXgnR2juODr8Nvf15hcSXSLeQ1Fmipn6ZdEFJo2JSOIF6MheS69npNOMYmrgKDMGa9O3SYqCo69CCQG0HZrkruMtGKWDOCj6wxwGqNtFYtRrJg5Xj758/3jk8US6GnP+yeVRnXb32NyRR4RCGv5rryLAnlcd8R9ZDGxXjmPnsV9Uc3Q7fx6P0SErNMXwUOCaWXJ01IR0tcNdBq6IIpu9+OJL5Ntk0bA8uge+x14wXS2Cq7l0eK1GQ2mHa3E9Howw2gTJSwkn3cEgqKrl9SvWqFNzebRF4eNtY3v6/sOZ4pgHCUBPEOpnDwRi8gf7N4HRtompTZp0tArUB/pK2NNRFsow0hTDXEgJmpsxdXvbL+aokLZFZbJHMYN3XGcGLbhnT3GBPt5rZE8f/8ga0DMZvBFKRANkJAAA=";
    private static final Logger log = LogManager.getLogger(ActorContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected People data;
    protected JSplitPane splitPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ActorContentUI $AbstractContentUI0;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTextPane $JTextPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ActorContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public ActorContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public ActorContentUI(LayoutManager param0) {
        super(param0);
    }

    public ActorContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public ActorContentUI() {
        
    }

    public ActorContentUI(JAXXContext param0) {
        super(param0);
    }

    public ActorContentUI(boolean param0) {
        super(param0);
    }

    public ActorContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public People getData() {
        return data;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(People data) {
        People oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTextPane get$JTextPane0() {
        return $JTextPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        splitPane.add($JScrollPane0, JSplitPane.LEFT);
        splitPane.add($JScrollPane1, JSplitPane.RIGHT);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $AbstractContentUI0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        createSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JTextPane0
        $objectMap.put("$JTextPane0", $JTextPane0 = new JTextPane());
        
        $JTextPane0.setName("$JTextPane0");
        $JTextPane0.setEditable(false);
        if ($JTextPane0.getFont() != null) {
            $JTextPane0.setFont($JTextPane0.getFont().deriveFont((float) 11));
        }
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setHorizontalAlignment(0);
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_PANE0_TEXT, true ,"data") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText($JTextPane0, getHandler().getContent(getData()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ICON, true ,"data") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setIcon(getHandler().getImage(getData()));
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $AbstractContentUI0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JTextPane0);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JLabel0);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 9 property setters
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        $JTextPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.actor.title")));
        $JScrollPane1.setBorder(new TitledBorder("Picture"));
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        $JScrollPane1.setMinimumSize(SwingUtil.newMinDimension());
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
