package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import static io.ultreia.java4all.i18n.I18n.t;

public class JRadioButtonMenuItemDemo extends JMenuItemDemo {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEMO_MESSAGE_FONT = "demoMessage.font";
    public static final String BINDING_DEMO_MESSAGE_TEXT = "demoMessage.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWzU4TURTHTyvlqygIhBhjTBNQSIQZQOMG5DsopJUENsRuvO1c2yHTmeu9d2BkwcKFO1/AhVs3hncgrkzcuOUdTHgEz53pFzqdjk4X0+b2f373f07OOe3XX5ARHGYdXtFs15SOrR0Rz9O4a0uzRrXd9cPDvdIRLcstKsrcZNLhELxSaUgXIWs0z4UErZhHkh6QdEXS6yR906kxx6Z2G2gpD4NCvrOoqFIqJcx0DC4LoR80lUsec3n9rlDXYXf9+LBwmaJbn9IAHkP7g5j2o38AtLLuyUPaNCSM5o/IMdEtYlfQHDftCiZ0U51tWkSIl6RG38IZ9OWhlxGOMAlz/1UeH+ejPCZheGq3QG13R9LaFq058xKe/ZmGgedauUHUxAl603b3iWE6G65EWTuAMZ/dK6GvhscbhEsYV1l4jcBCcNwmDCzg1bf/EirJUFM5MRV2LQbmrgWGaBRguAtnQX07Hke5GFv5OLbySYgyq0pfoEKQCsUOuZZknpSo1Spi/xvHlgfmKermOvVhPRKHMLj6OXdchggODzuF4KhorVFpdW2qCBnu4rGEyc5TqgZtH1XBiE12HjF1jS98f37Gv5xcXTbmahzN5bpFta0QbHLGHUa5NJW34WCoXGlaeoGwpSIMCGrh/vH3y3S084O6Et2jC783NUXSXhBRRVqm7/Li28TrnzcgvQ2DlkOMbaL0OzAgqxwr5liGx1bXfHNDJ/34HFE2JfRI6uH8ji6btmXaNEckDnzJlXTFwzpNR9epaet87+r7548PLhq1SqHLqTiRrXplXkFv4MHfQvUFE7p1skxQ13Ba2yNsn6TU+wirt+WM/5wNq0C21OpAJdI9f9Tn/TTUp0UfNdYVpY61RAQJmWNiudjdt5YNIkmuZNoGDspKEktPIyxNxLDUH7QpNRJxuhUnHmFVPdaSEKKqcSdxFvEIUVnEI0RlcTdxFvEIUVnEI0RlcS9xFvEIUVl0J+D+VD92EYz7MRhjVYebp8gh1rplVmz8tyIjEuuObJYmwtRv3ldi0yELAAA=";
    private static final Logger log = LogManager.getLogger(JRadioButtonMenuItemDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JAXXButtonGroup fontSize;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenu $JMenu0;
    private JRadioButtonMenuItemDemo $JMenuItemDemo0;
    private JRadioButtonMenuItem $JRadioButtonMenuItem0;
    private JRadioButtonMenuItem $JRadioButtonMenuItem1;
    private JRadioButtonMenuItem $JRadioButtonMenuItem2;
    private JRadioButtonMenuItem $JRadioButtonMenuItem3;
    private JRadioButtonMenuItem $JRadioButtonMenuItem4;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Font updateFont(Object selectedValue) {
        return UIManager.getFont("Label.font").deriveFont(selectedValue != null ? (float) ((Integer) selectedValue).intValue() : 12);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButtonMenuItemDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JRadioButtonMenuItemDemo(LayoutManager param0) {
        super(param0);
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JRadioButtonMenuItemDemo() {
        
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0) {
        super(param0);
    }

    public JRadioButtonMenuItemDemo(boolean param0) {
        super(param0);
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXButtonGroup getFontSize() {
        return fontSize;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem0() {
        return $JRadioButtonMenuItem0;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem1() {
        return $JRadioButtonMenuItem1;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem2() {
        return $JRadioButtonMenuItem2;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem3() {
        return $JRadioButtonMenuItem3;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem4() {
        return $JRadioButtonMenuItem4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMenuBar() {
        menuBar.add($JMenu0);
    }

    @Override
    protected void createDemoMessage() {
        super.createDemoMessage();
        demoMessage.setName("demoMessage");
        demoMessage.setHorizontalAlignment(0);
    }

    protected void createFontSize() {
        $objectMap.put("fontSize", fontSize = new JAXXButtonGroup());
    }

    @Override
    protected void createMenuBar() {
        super.createMenuBar();
        menuBar.setName("menuBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JMenuItemDemo0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$JMenuItemDemo0", $JMenuItemDemo0);
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("Font size"));
        // inline creation of $JRadioButtonMenuItem0
        $objectMap.put("$JRadioButtonMenuItem0", $JRadioButtonMenuItem0 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem0.setName("$JRadioButtonMenuItem0");
        $JRadioButtonMenuItem0.setText(t("10"));
        // inline creation of $JRadioButtonMenuItem1
        $objectMap.put("$JRadioButtonMenuItem1", $JRadioButtonMenuItem1 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem1.setName("$JRadioButtonMenuItem1");
        $JRadioButtonMenuItem1.setSelected(true);
        $JRadioButtonMenuItem1.setText(t("12"));
        // inline creation of $JRadioButtonMenuItem2
        $objectMap.put("$JRadioButtonMenuItem2", $JRadioButtonMenuItem2 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem2.setName("$JRadioButtonMenuItem2");
        $JRadioButtonMenuItem2.setText(t("14"));
        // inline creation of $JRadioButtonMenuItem3
        $objectMap.put("$JRadioButtonMenuItem3", $JRadioButtonMenuItem3 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem3.setName("$JRadioButtonMenuItem3");
        $JRadioButtonMenuItem3.setText(t("18"));
        // inline creation of $JRadioButtonMenuItem4
        $objectMap.put("$JRadioButtonMenuItem4", $JRadioButtonMenuItem4 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem4.setName("$JRadioButtonMenuItem4");
        $JRadioButtonMenuItem4.setText(t("24"));
        createFontSize();
        // inline creation of $JMenuItemDemo0
        setName("$JMenuItemDemo0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMO_MESSAGE_FONT, true) {
        
            @Override
            public void applyDataBinding() {
                if (fontSize != null) {
                    fontSize.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fontSize != null) {
                    demoMessage.setFont(updateFont(fontSize.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fontSize != null) {
                    fontSize.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMO_MESSAGE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (fontSize != null) {
                    fontSize.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fontSize != null) {
                    demoMessage.setText("Font size: " + (fontSize.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fontSize != null) {
                    fontSize.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        addChildrenToMenuBar();
        // inline complete setup of $JMenu0
        $JMenu0.add($JRadioButtonMenuItem0);
        $JMenu0.add($JRadioButtonMenuItem1);
        $JMenu0.add($JRadioButtonMenuItem2);
        $JMenu0.add($JRadioButtonMenuItem3);
        $JMenu0.add($JRadioButtonMenuItem4);
        // inline complete setup of $JRadioButtonMenuItem0
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem0); }
        
        // inline complete setup of $JRadioButtonMenuItem1
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem1); }
        
        // inline complete setup of $JRadioButtonMenuItem2
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem2); }
        
        // inline complete setup of $JRadioButtonMenuItem3
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem3); }
        
        // inline complete setup of $JRadioButtonMenuItem4
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem4); }
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 5 property setters
        { $JRadioButtonMenuItem0.putClientProperty("$value", 10);  Object $buttonGroup = $JRadioButtonMenuItem0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem1.putClientProperty("$value", 12);  Object $buttonGroup = $JRadioButtonMenuItem1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem2.putClientProperty("$value", 14);  Object $buttonGroup = $JRadioButtonMenuItem2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem3.putClientProperty("$value", 18);  Object $buttonGroup = $JRadioButtonMenuItem3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem4.putClientProperty("$value", 24);  Object $buttonGroup = $JRadioButtonMenuItem4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
