package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.VBox;
import static io.ultreia.java4all.i18n.I18n.t;

public class JCheckBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHp7U/aAERUBLjBaUIBt1V48WUgAghSqoYMYbYi9PdsR3czowzs7B64ODBm/+AB69eDP8D8WTixWv/BxP+BN9MS1tIW6rtYbadfe8z3/fmffv9D0oqiW5yWXZYSDVnzg6OIkeGTNMqcTZWtrc3SzvE02tEeZIKzSWqf2JxFC+iYb+5rzRyigUguXWSa0hug+Su8qrgjLA2UL6Askq/D4iqEKI1mu+a7CnlbjUj85EIZeOsjqo7nfXr051ajKx9iSMUCZCfhrIX/gHQqjpRQHHqazRR2MG72A0wK4M4SVkZCho1e6sBVuoprpJ3aB+lCyglsASYRrf+qz0WZ1GR0Gg4t0aq/BlmJLit0d3TJfjw0vGOaY7aA13OxmqFeG8f8sikCmFhKY1SuZewB5Rr3RpRTzdRJiXTzEznXuBSQCB1pneqDTNJI83cRIkH0L5LplPRaYEmZqwZOpTbKOCSLXTiRLjdPRmbohoH1DO/Lp58kwmZT2RAGWl/KdH1btJh3JzWuLVuPlZESRnCNpTdfdLNsD6HqPqYznQfU3OMDfx4sC+/7R3VjmczC+Kmz8pqsyEMipBcEKmp0TZWH8xQ08B9gkW+iDKKBOBh69G53sq3GpGgHlSMG5JjSM4jrCpAS6Zrhz+mXv8+h+LrKBtw7K9jE/8YZXRFQsfgciOx/MCKG9kbgvWCkanRZIVL+oEzuKaVgJZZ1VpiYpEyczXTWIOHSqEmSxG0ba5325oqDzaPfn79PHt43LoYiM71k9lqX/IVzI7VYI3d8GxHIw8LRUKftwzZyaIx8xwVDZtdtetsp4aM75ob89raYULno9A8bthizLeFvoEJTaJejMk+GENVBv8RrG6kATiJN9xc7/lFH2s8XaLMB+MudeZNnckz2/fMsjwwoUtNl/si3B+Y0EvDlYE1GMJfKhb2ktQHAAA=";
    private static final Logger log = LogManager.getLogger(JCheckBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox bold;
    protected JCheckBox italic;
    protected JCheckBox underline;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JCheckBoxDemo $DemoPanel0;
    private JLabel $JLabel0;
    private Table $Table0;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getText(boolean bold, boolean italic, boolean underline) {
            String text ="Sample Text";
            if (bold)
                text = "<b>" + text + "</b>";
            if (italic)
                text = "<i>" + text + "</i>";
            if (underline)
                text = "<u>" + text + "</u>";
            return "<html>" + text;
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JCheckBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JCheckBoxDemo(LayoutManager param0) {
        super(param0);
    }

    public JCheckBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JCheckBoxDemo() {
        
    }

    public JCheckBoxDemo(JAXXContext param0) {
        super(param0);
    }

    public JCheckBoxDemo(boolean param0) {
        super(param0);
    }

    public JCheckBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getBold() {
        return bold;
    }

    public JCheckBox getItalic() {
        return italic;
    }

    public JCheckBox getUnderline() {
        return underline;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBold() {
        $objectMap.put("bold", bold = new JCheckBox());
        
        bold.setName("bold");
        bold.setText(t("Bold"));
        bold.setMnemonic(66);
    }

    protected void createItalic() {
        $objectMap.put("italic", italic = new JCheckBox());
        
        italic.setName("italic");
        italic.setText(t("Italic"));
        italic.setMnemonic(73);
    }

    protected void createUnderline() {
        $objectMap.put("underline", underline = new JCheckBox());
        
        underline.setName("underline");
        underline.setText(t("Underline"));
        underline.setMnemonic(85);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createBold();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createItalic();
        createUnderline();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (bold != null) {
                    $bindingSources.put("bold.getModel()", bold.getModel());
                    bold.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    bold.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (italic != null) {
                    $bindingSources.put("italic.getModel()", italic.getModel());
                    italic.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    italic.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (underline != null) {
                    $bindingSources.put("underline.getModel()", underline.getModel());
                    underline.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    underline.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bold != null && italic != null && underline != null) {
                    $JLabel0.setText(getText(bold.isSelected(), italic.isSelected(), underline.isSelected()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bold != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("bold.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    bold.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (italic != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("italic.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    italic.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (underline != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("underline.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    underline.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($Table0);
        // inline complete setup of $Table0
        $Table0.add(bold, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(italic, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(underline, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        $JLabel0.setFont(new Font("Arial", 0, 18));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
