package org.nuiton.jaxx.demo.component.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import static io.ultreia.java4all.i18n.I18n.t;

public class DateTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";
    public static final String BINDING_EDITOR_DATE_EDITABLE = "editor.dateEditable";
    public static final String BINDING_EDITOR_DATE_FORMAT = "editor.dateFormat";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_LABEL = "editor.label";
    public static final String BINDING_EDITOR_TIME_EDITABLE = "editor.timeEditable";
    public static final String BINDING_RESULT_DATE_TEXT = "resultDate.text";
    public static final String BINDING_RESULT_DAY_DATE_TEXT = "resultDayDate.text";
    public static final String BINDING_RESULT_TIME_DATE_TEXT = "resultTimeDate.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XT28bRRQfmzhObLdJXLVFIKH8o3HasG5PgFKVkgS3VG6LSA4VuTD2TuwN491ldrZey2oPHLjxBThw5YL6HSpOSFy4gJTvgNSPwJsZ71+v7W1CpG4mb9783nu/mfm96W//ooLD0I7FOprpGtwytVPseRpzTW70iPbo82fPnrZOSZsfEKfNDJtbDKmfXB7lj1FZD+wOR9pxE5DqCqkukOojpPq+1bMtk5gRoN0mKjl8QInTJYRzVJu4uO049cPAc9ezXTaKlZp1Wqw/f7xzliMHP+cR8mxI/wqUfestAMKq55oob+gcVZun+DmuU2x2IDlmmB0o6JKw7VPsOE9wj3yPXqJiE83bmAEYRx+dix4JJ6E8m6Py5gHpWV9hk9DbHD1IlqDDpNb20ZStb+gdwh1Nx5zI+g5gcASDL3RYyASebcsI8xwVepZOKEdj7J4T+bGAC+EXNh/5uVcFV57m9IE6TVmF02LgW25b5onRkTMcbUzaLQVwhFtUEr4UrF+muEXovgRpimEypjQK52oYM7KGo2sx9yPi8YZBqB5fsnJisR7mkThi4nrcqRJ1Erb34vNVQaFgTZSx53KokqOrsfD7XdL+bs/yEgv5iO5woZhZS4Qn5tT5eSI3jKN6kuUZWxxnfJ4Rx6Vc/LUS38slNSMWxynaDlxKoUtAUDhb9WcH0zAuxbxSYK4oB1HANJzLcbcoEEM3Jp1E0Ckt1KlQMnLHqMBcMMMpniyRQuW+Bi+lbxuT9U2EkY4/vHrJfu2/OYuK2uqsVRH9BoWxmWUTxg2R25JSNJcbtP4Y27vHaNEhFMRfivvW9MwPR56QPWSxIpA0gaQ9xE4X0ArFs9e/X/v2r3dQvoFK1MJ6Awv/L9Ei7wLbXYvqnv3ZfZlcpb8A32X4l4dD1bKYDjmie0OT9FePDE6JvidtNV5bF5lIbfJPqDrKmhIPl2FuWOb69vYLQKJ4YMEVQFcl0gNm6E1pqd3eubP9wgPat6bTHlT56umbP3756cPXPvU5KHozy8qQ/sI3aN4wqWES2VFGzSK1g5Rth7i6FXaCtN6A4oppj0T3rvzeH2M2x9EcB0Xj6FYmCjWpjJ4r0BqyYjF6iFJ0NnvoT4ZZd1CF155j6pJ1sVfjeUS1O3sKO9nCK/1OCzuu/9mDf5q9fhVlKgGxJjMriXyQxAeTElBNA5q2kgGiiyXMJamxox0me+zNSbGj/TBbBikt9H/II9peM+Yx3pFn5VGOqNzHb6Vy6peStzk5h1aG8gmnQdsWvasmpiojnZdtMfBc9q1+n4MCeTCsxLdgbTjOr2Y4hyNCZJilMMwoUlH3RyWxvCEPKEfvDqNHVaQqHlcSo0DVU+36MHKdYx5zLYLhdVRUdYKhqM4ebMr7w+gxTKZXiW/m2nB8p+JL0rZ39FTKcMfPuaXq6SG2NDW8ms4uMRvT40hrWqDkiy3DXVogAbeFE0wdEiSxPuxiU6eEBacycUbTi408CbMXfGNmwfJEpl7d8UfmhcquxcseJCsfTCs+/pbNXv/WjPr9G54WM+15fCEGbkYZ8GFDCgLLBA4S7/Asl85/412+C+Xj1ZZh6vDfp3tj6DnxLc1EFOa/xeefdITlCyPcBIT/AJd4euiJEQAA";
    private static final Logger log = LogManager.getLogger(DateTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected JCheckBox dateEditableButton;
    protected DateTimeEditor editor;
    protected JCheckBox enableButton;
    protected JTextField formatConfig;
    protected JLabel formatConfigLabel;
    protected DateTimeEditorDemoHandler handler;
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected DateTimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultDate;
    protected JLabel resultDateLabel;
    protected JTextField resultDayDate;
    protected JLabel resultDayDateLabel;
    protected JTextField resultTimeDate;
    protected JLabel resultTimeDateLabel;
    protected JCheckBox timeEditableButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditorDemo $DemoPanel0;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public DateTimeEditorDemo(LayoutManager param0) {
        super(param0);
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public DateTimeEditorDemo() {
        
    }

    public DateTimeEditorDemo(JAXXContext param0) {
        super(param0);
    }

    public DateTimeEditorDemo(boolean param0) {
        super(param0);
    }

    public DateTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public JCheckBox getDateEditableButton() {
        return dateEditableButton;
    }

    public DateTimeEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JTextField getFormatConfig() {
        return formatConfig;
    }

    public JLabel getFormatConfigLabel() {
        return formatConfigLabel;
    }

    public DateTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public DateTimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultDate() {
        return resultDate;
    }

    public JLabel getResultDateLabel() {
        return resultDateLabel;
    }

    public JTextField getResultDayDate() {
        return resultDayDate;
    }

    public JLabel getResultDayDateLabel() {
        return resultDayDateLabel;
    }

    public JTextField getResultTimeDate() {
        return resultTimeDate;
    }

    public JLabel getResultTimeDateLabel() {
        return resultTimeDateLabel;
    }

    public JCheckBox getTimeEditableButton() {
        return timeEditableButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfigLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfig, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(dateEditableButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(timeEditableButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(enableButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        result.add(resultDateLabel);
        result.add(resultDate);
        result.add(resultDayDateLabel);
        result.add(resultDayDate);
        result.add(resultTimeDateLabel);
        result.add(resultTimeDate);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
        configPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDateEditableButton() {
        $objectMap.put("dateEditableButton", dateEditableButton = new JCheckBox());
        
        dateEditableButton.setName("dateEditableButton");
        dateEditableButton.setText(t("jaxxdemo.datetimeeditor.dateEditable"));
        dateEditableButton.setSelected(true);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new DateTimeEditor(this));
        
        editor.setName("editor");
        editor.setPropertyDate("date");
        editor.setPropertyTimeDate("timeDate");
        editor.setPropertyDayDate("dayDate");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
        enableButton.setText(t("jaxxdemo.datetimeeditor.enable"));
        enableButton.setSelected(true);
    }

    protected void createFormatConfig() {
        $objectMap.put("formatConfig", formatConfig = new JTextField());
        
        formatConfig.setName("formatConfig");
        formatConfig.setColumns(15);
    }

    protected void createFormatConfigLabel() {
        $objectMap.put("formatConfigLabel", formatConfigLabel = new JLabel());
        
        formatConfigLabel.setName("formatConfigLabel");
        formatConfigLabel.setText(t("jaxxdemo.datetimeeditor.configuration.format"));
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
        labelConfigLabel.setText(t("jaxxdemo.datetimeeditor.configuration.label"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DateTimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultDate() {
        $objectMap.put("resultDate", resultDate = new JTextField());
        
        resultDate.setName("resultDate");
        resultDate.setColumns(15);
        resultDate.setEditable(false);
    }

    protected void createResultDateLabel() {
        $objectMap.put("resultDateLabel", resultDateLabel = new JLabel());
        
        resultDateLabel.setName("resultDateLabel");
        resultDateLabel.setText(t("jaxxdemo.datetimeeditor.result.date"));
    }

    protected void createResultDayDate() {
        $objectMap.put("resultDayDate", resultDayDate = new JTextField());
        
        resultDayDate.setName("resultDayDate");
        resultDayDate.setColumns(15);
        resultDayDate.setEditable(false);
    }

    protected void createResultDayDateLabel() {
        $objectMap.put("resultDayDateLabel", resultDayDateLabel = new JLabel());
        
        resultDayDateLabel.setName("resultDayDateLabel");
        resultDayDateLabel.setText(t("jaxxdemo.datetimeeditor.result.dayDate"));
    }

    protected void createResultTimeDate() {
        $objectMap.put("resultTimeDate", resultTimeDate = new JTextField());
        
        resultTimeDate.setName("resultTimeDate");
        resultTimeDate.setColumns(15);
        resultTimeDate.setEditable(false);
    }

    protected void createResultTimeDateLabel() {
        $objectMap.put("resultTimeDateLabel", resultTimeDateLabel = new JLabel());
        
        resultTimeDateLabel.setName("resultTimeDateLabel");
        resultTimeDateLabel.setText(t("jaxxdemo.datetimeeditor.result.timeDate"));
    }

    protected void createTimeEditableButton() {
        $objectMap.put("timeEditableButton", timeEditableButton = new JCheckBox());
        
        timeEditableButton.setName("timeEditableButton");
        timeEditableButton.setText(t("jaxxdemo.datetimeeditor.timeEditable"));
        timeEditableButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new DateTimeEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createFormatConfigLabel();
        createFormatConfig();
        createDateEditableButton();
        createTimeEditableButton();
        createEnableButton();
        createEditor();
        createResult();
        createResultDateLabel();
        createResultDate();
        createResultDayDateLabel();
        createResultDayDate();
        createResultTimeDateLabel();
        createResultTimeDate();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setDate(model.getDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (dateEditableButton != null) {
                    $bindingSources.put("dateEditableButton.getModel()", dateEditableButton.getModel());
                    dateEditableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    dateEditableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (dateEditableButton != null) {
                    editor.setDateEditable(dateEditableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (dateEditableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("dateEditableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    dateEditableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_EDITABLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatConfig != null) {
                    $bindingSources.put("formatConfig.getDocument()", formatConfig.getDocument());
                    formatConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    formatConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_FORMAT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatConfig != null) {
                    editor.setDateFormat(formatConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatConfig != null) {
                    Document $target = (Document) $bindingSources.remove("formatConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    }
                    formatConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_DATE_FORMAT));
                }
            }
        
            public void $pr$u1(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LABEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (labelConfig != null) {
                    $bindingSources.put("labelConfig.getDocument()", labelConfig.getDocument());
                    labelConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    labelConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (labelConfig != null) {
                    editor.setLabel(labelConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (labelConfig != null) {
                    Document $target = (Document) $bindingSources.remove("labelConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    }
                    labelConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            public void $pr$u2(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enableButton != null) {
                    $bindingSources.put("enableButton.getModel()", enableButton.getModel());
                    enableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    enableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enableButton != null) {
                    editor.setEnabled(enableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    enableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TIME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (timeEditableButton != null) {
                    $bindingSources.put("timeEditableButton.getModel()", timeEditableButton.getModel());
                    timeEditableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    timeEditableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_TIME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (timeEditableButton != null) {
                    editor.setTimeEditable(timeEditableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (timeEditableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("timeEditableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    timeEditableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.datetime.DateTimeEditorDemo.this, BINDING_EDITOR_TIME_EDITABLE));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultDate, handler.getDate(model.getDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DAY_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dayDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultDayDate, handler.getDayDate(model.getDayDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dayDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_TIME_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultTimeDate, handler.getTimeDate(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 10 property setters
        configPanel.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.configuration")));
        SwingUtil.setText(labelConfig, t("jaxxdemo.datetimeeditor.configuration.label.value"));
        
        SwingUtil.setText(formatConfig, t("jaxxdemo.datetimeeditor.configuration.format.value"));
        
        editor.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.editor")));
        editor.setBean(model);
        result.setBorder(new TitledBorder(t("jaxxdemo.datetimeeditor.result")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
