package org.nuiton.jaxx.demo;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import static io.ultreia.java4all.i18n.I18n.t;

public class DemoTab extends JTabbedPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SOURCE_TABS_SOURCES = "sourceTabs.sources";
    public static final String BINDING_TAB_DEMO_PANEL_TITLE = "tabDemoPanel.title";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1TO28TQRAeO7GN8+IlqCJk4TyQgDtRJ+KhRBFBhiBMEeGGtW9JLjrvLrtz+GhSUNDxByhoaVD+Q0SFREPr/4CUn8Ds+uKzEl8IXLF3mpv55pvZ7/v2G0pGwx2pdzwRhyiFt8eSxNOxwLDLvSePtre32nu8g+vcdHSoUGoYPIUiFFswHQzjBsFrNQjJHyD5FslPkfw12VVScDECtNKAKYPvI252OUeEW7nFHWP85jBzJVGxTnuNZT2u18+P9/oFvv65CJAoom/Hvv0PANnUkw0ohgHClcYee8f8iIkdIqdDsUMDzdrYWsSMeca6/C3sQ6UBZcU0gSHc/a/1ODgHlSiECZR0zp+kHvCu9NbpeMnaSrn0MsIMsrYNPmeCRwiLeQObHtH3qHRTvJFZeTXIam/kdnQJtqI6LJxL+zZlrDvcRecy2CnjwtSONFPLxR0pJmQNS3nsSR5eJo/spgotKOmYwgj1fGVacb2grIGs6vmysm1c4oeDff21d9Q/1tIkkTs1xsmqEdvQxSotFdcYWm4XB0KKMYz8p0yttKBqeESec55aPpt5M80k9sTiskXyLJL3mJldQitV+offr7/+NQHFDZiKJAs2mM3fhCruatqYjIJEPXjoyM30LtB5ydJEKGGIEa1zbjVgyGrtUAQkkvsJLWn57CUNOR1sHf348mnx8HhRBaK4cJ7KbFmlV1AORRQK7myXOmqszaaV4XEgM7uMM1DBvmdVKsZ5d9ZOj2/DN8njq4PeNYbk8HaMnOa3/xbcNPZryeVe/SsiwmwoOrJLOxzyqY8Hu3YOsIrJ3HEGzB9GP73+4QUAAA==";
    private static final Logger log = LogManager.getLogger(DemoTab.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoPanel demoPanel;
    protected DemoSources sourceTabs;
    protected TabInfo tabDemoPanel;
    protected TabInfo tabDemoSources;
    protected DemoTab top;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                if (demoPanel.getSources().length == 0) {
                   top.remove(sourceTabs);
                   return;
                }
                sourceTabs.init();
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoTab(int param0) {
        super(param0);
        $initialize();
    }

    public DemoTab(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoTab(int param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoTab(JAXXContext parentContext, int param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoTab() {
        $initialize();
    }

    public DemoTab(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoPanel getDemoPanel() {
        return demoPanel;
    }

    public DemoSources getSourceTabs() {
        return sourceTabs;
    }

    public TabInfo getTabDemoPanel() {
        return tabDemoPanel;
    }

    public TabInfo getTabDemoSources() {
        return tabDemoSources;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTop() {
        add(demoPanel);
        add(sourceTabs);
        tabDemoPanel.install(top, 0);
        tabDemoSources.install(top, 1);
    }

    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = getContextValue(DemoPanel.class, "content"));
        
        demoPanel.setName("demoPanel");
    }

    protected void createSourceTabs() {
        $objectMap.put("sourceTabs", sourceTabs = new DemoSources(demoPanel));
        
        sourceTabs.setName("sourceTabs");
    }

    protected void createTabDemoPanel() {
        $objectMap.put("tabDemoPanel", tabDemoPanel = new TabInfo("tabDemoPanel"));
    }

    protected void createTabDemoSources() {
        $objectMap.put("tabDemoSources", tabDemoSources = new TabInfo("tabDemoSources"));
        
        tabDemoSources.setTitle(t("Sources"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createTabDemoPanel();
        createDemoPanel();
        createTabDemoSources();
        createSourceTabs();
        // inline creation of top
        setName("top");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAB_DEMO_PANEL_TITLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoPanel != null) {
                    demoPanel.addPropertyChangeListener("demoTabTitle", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoPanel != null) {
                    tabDemoPanel.setTitle(demoPanel.getDemoTabTitle());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoPanel != null) {
                    demoPanel.removePropertyChangeListener("demoTabTitle", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_TABS_SOURCES, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoPanel != null) {
                    demoPanel.addPropertyChangeListener("sources", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoPanel != null) {
                    sourceTabs.setSources(Arrays.asList(demoPanel.getSources()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoPanel != null) {
                    demoPanel.removePropertyChangeListener("sources", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 1 property setters
        sourceTabs.setIncomingClass(demoPanel.getClass());
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
