package org.nuiton.jaxx.demo.feature.nav;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.DemoDataProvider;
import org.nuiton.jaxx.demo.feature.nav.tree.NavDemoTreeHelper;
import org.nuiton.jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.CardLayout2;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import org.nuiton.jaxx.runtime.swing.TabInfoPropertyChangeListener;
import static org.nuiton.i18n.I18n.t;

public class NavDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Wz28bRRTHxwY7OGnTElBLhUQj6hB+dU05gERCaUlapZbbRE2EArkw3p3EE8Yzw8yss+mhBw7c+Ac4cOWC+j9UnJC4cM3/gNQ/gfd2N7s2rJ2lbg5ONPPeZ77vzZuv89vfpGYN+VCZA0+G3CnpHdIo8kwoHe8zr317d3eze8h8t86sb7h2ypDkp1Il1T0yF2Tr1hFvrwOkVkJqIamVklprqq+VZHIItNIhs9YdC2Z7jDlH3h2b7Fvb2s4iVyIdmvSsQtVFZ/35442TClv/uUpIpEH+PJT9wf8A5FW/3CFVHjiy0DmkA9oSVB6AOMPlARR0HtfWBLX2Ae2z78ljMtMhdU0NwBy5/lztiXExKtKOzDXXWV9tUcnER9Czf5cQwKa3z6gLDfMkHXgP6AATtI4RdUfO+0o6OKlDj1UIot4b1wV7BDV5a9QESejHOeNcQB3dMmrAA2bg3gtVwBnccWY9PH99KCHnzDrD2AYTGimfnlkLRp8WtJNl5rgLGLBDuyJj3i7FdJgyDB5i5PSG1YI77Lwjl/Ceo7RF7e3TDYxs5J1utgHUZQFuwWVdHknKtzD8jeGsbd8oIQqz8i0MfzPLmoda+AF1XEkswJFXRw+DNYx8q/iYG7i4OEp8bZQYt8SRq9jQQ3j13zmlE3rktXezCExuZoyZdNbgtYzIicd3tOxGE/LvyX0FJS9NHsk0UP83N67Dgw1D3hnHADPxcjPJ33Vlj9RMCMuOXBvvY2hFDyEqMaFr400Ij4kDf3jy2Px69Ozk1HkWQNziWVlDJgs2oI3Caeao7UJiO6HjonWf6pU9mEsmwKFjB16erHw7jQT1oCIeEQ9J3ga1PaDVZk6e/n7p279eItW7ZFYoGtylGH+PNFzPQMeUCCL9xa1Y3LmjV+DzIsp0pC5SO5lfRW9Y7HIZwF3djKBLy5O7lIl6svnsj19+Wnp62qkKaGyWycy7VfuG1LkUXLLYpVMDLnTlOW1ZGKjcXYv8toK/Z3U6ap/En58V1b8A7r2jQr93J9JUBsljWVhNtCxSB18Q3dAx6AcibsbV4V+34hOulDih3lUGzBP3Py+mXC1BudJThj+CV0lF8vy/pGZLCe4fTwm+PMAJ9V80trEPWq9b/ii+tjvFoLdLgGp9FSSeM0ZNGcicUcp9xS1PnW4KPRfhMR3Zh8DbgHkB25mKh8vtCcUtlSJsTk3YmYrgyOu+EmFfrsGlwxSd3enlUqq+nprgT03oTUUAX83+t7l/xiCX07M6gfA+EP4B8C0FRBsMAAA=";
    private static final Log log = LogFactory.getLog(NavDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected DemoDataProvider dataProvider;
    protected NavDemoHandler handler;
    protected JTree navigationTree;
    protected JXTreeTable navigationTreeTable;
    protected JSplitPane splitPane;
    protected NavDemoTreeHelper treeHelper;
    protected NavDemoTreeTableHelper treeTableHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NavDemo $DemoPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources(
                "tree/NavDemoTreeNode.java",
                "tree/NavDemoTreeHelper.java",
                "tree/NavDemoTreeCellRenderer.java",
                "tree/ActorsTreeNodeLoador.java",
                "tree/MoviesTreeNodeLoador.java",
                "treetable/NavDemoTreeTableNode.java",
                "treetable/NavDemoTreeTableHelper.java",
                "treetable/ActorsTreeTableNodeLoador.java",
                "treetable/MoviesTreeTableNodeLoador.java"
         );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NavDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public NavDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public NavDemo(LayoutManager param0) {
        super(param0);
    }

    public NavDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public NavDemo() {
        
    }

    public NavDemo(JAXXContext param0) {
        super(param0);
    }

    public NavDemo(boolean param0) {
        super(param0);
    }

    public NavDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoDataProvider getDataProvider() {
        return dataProvider;
    }

    public NavDemoHandler getHandler() {
        return handler;
    }

    public JTree getNavigationTree() {
        return navigationTree;
    }

    public JXTreeTable getNavigationTreeTable() {
        return navigationTreeTable;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public NavDemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    public NavDemoTreeTableHelper getTreeTableHelper() {
        return treeTableHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        splitPane.add($JTabbedPane0, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
    }

    protected void createDataProvider() {
        $objectMap.put("dataProvider", dataProvider = new DemoDataProvider());
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new JTree());
        
        navigationTree.setName("navigationTree");
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setRootVisible(false);
        navigationTree.setShowsRootHandles(false);
    }

    protected void createNavigationTreeTable() {
        $objectMap.put("navigationTreeTable", navigationTreeTable = new JXTreeTable());
        
        navigationTreeTable.setName("navigationTreeTable");
        navigationTreeTable.setColumnControlVisible(true);
        if (navigationTreeTable.getFont() != null) {
            navigationTreeTable.setFont(navigationTreeTable.getFont().deriveFont((float) 11));
        }
        navigationTreeTable.setRootVisible(false);
        navigationTreeTable.setShowsRootHandles(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = new NavDemoTreeHelper(getDataProvider()));
    }

    protected void createTreeTableHelper() {
        $objectMap.put("treeTableHelper", treeTableHelper = new NavDemoTreeTableHelper(getDataProvider()));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new NavDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createContentLayout();
        createDataProvider();
        createTreeHelper();
        createTreeTableHelper();
        createSplitPane();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createNavigationTreeTable();
        createContent();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo("$TabInfo0"));
        
        $TabInfo0.setTitle(t("jaxxdemo.tree.tabtitle"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo("$TabInfo1"));
        
        $TabInfo1.setTitle(t("jaxxdemo.treeTable.tabtitle"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add($JScrollPane0);
        $JTabbedPane0.add($JScrollPane1);
        $TabInfo0.setTabIndex(0);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, t("jaxxdemo.tree.tabtitle"));
        $TabInfo1.setTabIndex(1);
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, t("jaxxdemo.treeTable.tabtitle"));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(navigationTreeTable);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 10 property setters
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTree.setModel(treeHelper.createModel());
        $JScrollPane1.setBorder(null);
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTreeTable.setTreeTableModel(treeTableHelper.createModel());
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
