package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.VBox;
import static org.nuiton.i18n.I18n.t;

public class JDialogDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVTU8TQRjHp5WW97caiRIPjVTxjS1oPBgQ5CUNNkWIEEPkwrQ7KYPTmXV2FhYPmHjw5hfw4NWL4TsQTyZevPIdTPgIPrPbd9pltT1s25nn+c3//+w+z37/g2K2RA+FLBrcoUpwYx+7riEdrmiJGNnF7e31/D4pqBViFyS1lJDI/0SiKLqD+s3quq2QsZMDUtonpTUpXSall0XJEpzwOtBsDvXZ6ogRe48QpdDdtskF205vViNnXcuR5bNaqm511q9PM2cRsvIlipBrgfxhsP3gHwA11105FKWmQoncPj7AaYZ5EcRJyotgaFCvLTNs2y9xibxDx6g7h+IWlgBTaOq/yuPhPJRrKdSfWiElsYE5YdMKTTdbMGHTKFRohn0IuozsCsVMFHWiZXmouELx1Osl4QLjVrsy+Mk6Sqf0VjN7U9klR0E4JF/Vht3KOf6yDhtoOmdG/xtq3OlJZXM47/lINGC8VR2UuBDrccYa9+KmZ69ZjG+6Zrg7tYXzjMBpE8GOvTCddOPC8Y+qx9+s7g06NpEcbneGEgYPxliDii3iKm+jMakCfNwKaMENPxTSLAPHG4Ab9ZsXoJUHI9GUw/2C1mKj4q3+Naov9y7e2pn6TYnutKsYtKZRa81al0R2UEw6sAzVbj8VdGO/gii/pSfat7Q+xgv8eHIsvx2en1X6OAHikpdl1Y0saCpLCotIRbW2Yb+JHUVZeg1bszuo1yYM5p03zyaDlW+WI0E9qBjVJEOTjFVs7wEt1n12+mNs9/cVFM2gPiawmcE6/gXqVXsSKiaY6VoLzz1xA4c9cB3RMuFB3hOSvhdcYbbIaJGXvPGRmKOcUU6SWMG8yTuKzLtQtsngslVVnqyf//z6+fZppXQREJ0Kk1krX+wNivsavCFYnm8th16/ZRPHFLXh1WqcRfT3oFXu0Sfe9Wmrgowe6DtWqCuHDp1zHf31zDOjfy2EBnYp6MsAxsilDL28qtDQnIkVTuYpN6HV5lvTroWj6ctaa8L1EJ5iJWFiFmBqPAxEUeVPvw4gPUzPtoyQAY6S4WvSRsnlBHhwTGpbDB8Rc43D64/TQkdAvbwbYOp2x6bCEWhHBHhlQkmEowKc3A9DgXFG/fd9G8pUx/UIR/gQoCHdsQZN+AuUIMEdKwsAAA==";
    private static final Log log = LogFactory.getLog(JDialogDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JDialog dialog;
    protected JButton ok;
    protected JPasswordField passwordField;
    protected JTextField usernameField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JDialogDemo $DemoPanel0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JPanel $JPanel0;
    private Table $Table0;
    private VBox $VBox0;
    private VBox $VBox1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    String username;
    String password;
    private class OKAction extends javax.swing.AbstractAction {
        public OKAction() {
        putValue(NAME, "OK");
        }
    
        public void actionPerformed(ActionEvent e) {
        username = usernameField.getText();
        password = new String(passwordField.getPassword());
        dialog.dispose();
        }
        }private class CancelAction extends javax.swing.AbstractAction {
        public CancelAction() {
        putValue(NAME, "Cancel");
        }
    
    
        public void actionPerformed(ActionEvent e) {
        dialog.dispose();
        }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JDialogDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JDialogDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JDialogDemo(LayoutManager param0) {
        super(param0);
    }

    public JDialogDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JDialogDemo() {
        
    }

    public JDialogDemo(JAXXContext param0) {
        super(param0);
    }

    public JDialogDemo(boolean param0) {
        super(param0);
    }

    public JDialogDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dialog.setVisible(true);
    }

    public void doWindowOpened__on__dialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dialog.setLocationRelativeTo(JDialogDemo.this);                                                                     passwordField.setText("");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JDialog getDialog() {
        return dialog;
    }

    public JButton getOk() {
        return ok;
    }

    public JPasswordField getPasswordField() {
        return passwordField;
    }

    public JTextField getUsernameField() {
        return usernameField;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    protected VBox get$VBox1() {
        return $VBox1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        dialog.getContentPane().add($Table0);
    }

    protected void createDialog() {
        $objectMap.put("dialog", dialog = new JDialog());
        
        dialog.setName("dialog");
        dialog.setModal(true);
        dialog.setTitle(t("Sign on"));
        dialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowOpened", this, "doWindowOpened__on__dialog"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("OK"));
    }

    protected void createPasswordField() {
        $objectMap.put("passwordField", passwordField = new JPasswordField());
        
        passwordField.setName("passwordField");
        passwordField.setColumns(15);
    }

    protected void createUsernameField() {
        $objectMap.put("usernameField", usernameField = new JTextField());
        
        usernameField.setName("usernameField");
        usernameField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("Show password dialog"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $VBox1
        $objectMap.put("$VBox1", $VBox1 = new VBox());
        
        $VBox1.setName("$VBox1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        createDialog();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("Username:"));
        $JLabel2.setDisplayedMnemonic(85);
        createUsernameField();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("Password:"));
        $JLabel3.setDisplayedMnemonic(80);
        createPasswordField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0, 6, 6));
        createOk();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("Cancel"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        {
            JRootPane rootPane = dialog.getRootPane();
            rootPane.setDefaultButton(ok);
            rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"),
            "cancel");
            rootPane.getActionMap().put("cancel", new CancelAction());
            };
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"username") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(t(username != null ? "Username: " + username : ""));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_TEXT, true ,"password") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setText(t(password != null ? "Password: " + password : ""));
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JButton0);
        $VBox0.add($VBox1);
        // inline complete setup of $VBox1
        $VBox1.add($JLabel0);
        $VBox1.add($JLabel1);
        addChildrenToDialog();
        // inline complete setup of $Table0
        $Table0.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(usernameField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(passwordField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(ok);
        $JPanel0.add($JButton1);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 5 property setters
        $JLabel2.setLabelFor(usernameField);
        $JLabel3.setLabelFor(passwordField);
        ok.setAction(new OKAction());
        $JButton1.setAction(new CancelAction());// late initializer
        dialog.pack();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
