package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n.t;

public class JCheckBoxMenuItemDemo extends JMenuItemDemo {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENTS_EDITABLE = "comments.editable";
    public static final String BINDING_COMMENTS_ENABLED = "comments.enabled";
    public static final String BINDING_EMAIL_EDITABLE = "email.editable";
    public static final String BINDING_EMAIL_ENABLED = "email.enabled";
    public static final String BINDING_FIRST_NAME_EDITABLE = "firstName.editable";
    public static final String BINDING_FIRST_NAME_ENABLED = "firstName.enabled";
    public static final String BINDING_LAST_NAME_EDITABLE = "lastName.editable";
    public static final String BINDING_LAST_NAME_ENABLED = "lastName.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWy1ITURDtRMJLMaiIC7WMEgVLnYiuFF88pDQGsYQFJRtvMhdycTJzvdORsSxduHDnD7hw68biHyhXVrlxyz9YxSfYdyaTF8kkGqoyRZrTp/v0vX2G738g4Sq46qhNwy4LdGxji3meoco2ihI3srNra8v5LV7ABe4WlJDoKAh+YnGIr8Nhsxp3EYz1HDFlAqaMZspUmDLzTkk6NrfriGZyMOziW4u7Rc4RYaptcsF1MytV5Iwny6pSq2XXrWr9+jS9F+MLX+IAnqT2kyT7yj8Q1FT35SAuTITjuS32hmUsZm9Sc0rYmyRoRMfmLea6T1mJv4YPMJCDfskUkSFc+6/x+HQ+lScRkunsErfLj5GXFnjJuY5wu1mGSXGjEDIa7jb1ZmTni7zwas7x6rOl9In7EQZKFJ5jCmFMS/DCrKUgXAcM6lPdYweAGnKkikxym+UtboaFEc42ZDQ3pNOS1exRbgrU+SFMx8caMcMbiqb8jNncQphod5pBuVXNVZMxmM7mWJ5bpON4Q1d+VINOVbFDG4Jutz5QhPEG8Cr3cFFwy/QTEPo2HFVqLjGtv59ppBykM8XwipyLyr7RIjvBS0xYHVNvtkgdSWdXCsqxLD01En+qQU/tT03t0m2iC4K04ycPDGBWcaZx18I2FFxqdxa0yUZtk2tLFVuHhCpTmM6xvYloH3hOqMABJto7gC7jAz/ufFDftvf3wrUfo+ZSnbLqHI52UCpHcoVC95YMdr6MwsosMTmzDkMut8geffubjO58pYKk7qkLf3sMzWQ8Ym6R2BIDe7s/xl/+PgTxRRi2HGYuMo1/DENYVDQxxzI9ef+B39yR7UF6jtInTscT7grC+Xep5sUxhBuU5ubU5dR7WuHKYiKkCN24pE1gj+Y8GT3nqqyd5f2fXz9f3A1nHSOV6W4ya/NOvIB+YVvC5r7JVvyzpakeli4vm07NHFvZJUgp65fjlv+8e2CGMQIhXWUygztB/RRD8vR8Gfk9z/e1eV+R/u1hTD9HZcVMIjgH3cooNeJJa54THXl0ONszw7MIhvGee+jM4HsemdKiQ++Yo3dMhiyVF7ZJNtJmwqd77qozA73FTOFKi73l5pJNb0RbFHoi1GHfDfOtGS70LKo7hlc9M0SpmOxZRXcMUSq6Y4hScbVnFd0xRKnozIDQX+Ris4gRLEYXLIlt+q+12IHkL6n73BARDAAA";
    private static final Log log = LogFactory.getLog(JCheckBoxMenuItemDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea comments;
    protected JCheckBoxMenuItem editableCheckBox;
    protected JTextField email;
    protected JCheckBoxMenuItem enabledCheckBox;
    protected JTextField firstName;
    protected JTextField lastName;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JMenu $JMenu0;
    private JCheckBoxMenuItemDemo $JMenuItemDemo0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBoxMenuItemDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JCheckBoxMenuItemDemo(LayoutManager param0) {
        super(param0);
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JCheckBoxMenuItemDemo() {
        
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0) {
        super(param0);
    }

    public JCheckBoxMenuItemDemo(boolean param0) {
        super(param0);
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getComments() {
        return comments;
    }

    public JCheckBoxMenuItem getEditableCheckBox() {
        return editableCheckBox;
    }

    public JTextField getEmail() {
        return email;
    }

    public JCheckBoxMenuItem getEnabledCheckBox() {
        return enabledCheckBox;
    }

    public JTextField getFirstName() {
        return firstName;
    }

    @Override
    public Table getFramePanel() {
        return (Table) super.getFramePanel();
    }

    public JTextField getLastName() {
        return lastName;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFramePanel() {
        framePanel.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(firstName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(lastName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(email, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JScrollPane0, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMenuBar() {
        menuBar.add($JMenu0);
    }

    protected void createComments() {
        $objectMap.put("comments", comments = new JTextArea());
        
        comments.setName("comments");
        comments.setColumns(15);
        comments.setLineWrap(true);
        comments.setWrapStyleWord(true);
    }

    protected void createEditableCheckBox() {
        $objectMap.put("editableCheckBox", editableCheckBox = new JCheckBoxMenuItem());
        
        editableCheckBox.setName("editableCheckBox");
        editableCheckBox.setSelected(true);
        editableCheckBox.setText(t("Editable"));
    }

    protected void createEmail() {
        $objectMap.put("email", email = new JTextField());
        
        email.setName("email");
        email.setColumns(15);
    }

    protected void createEnabledCheckBox() {
        $objectMap.put("enabledCheckBox", enabledCheckBox = new JCheckBoxMenuItem());
        
        enabledCheckBox.setName("enabledCheckBox");
        enabledCheckBox.setSelected(true);
        enabledCheckBox.setText(t("Enabled"));
    }

    protected void createFirstName() {
        $objectMap.put("firstName", firstName = new JTextField());
        
        firstName.setName("firstName");
        firstName.setColumns(15);
    }

    @Override
    protected void createFramePanel() {
        super.createFramePanel();
        framePanel.setName("framePanel");
    }

    protected void createLastName() {
        $objectMap.put("lastName", lastName = new JTextField());
        
        lastName.setName("lastName");
        lastName.setColumns(15);
    }

    @Override
    protected void createMenuBar() {
        super.createMenuBar();
        menuBar.setName("menuBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JMenuItemDemo0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$JMenuItemDemo0", $JMenuItemDemo0);
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("View"));
        createEnabledCheckBox();
        createEditableCheckBox();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("First Name:"));
        $JLabel0.setDisplayedMnemonic(70);
        createFirstName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Last Name:"));
        $JLabel1.setDisplayedMnemonic(76);
        createLastName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("Email Address:"));
        $JLabel2.setDisplayedMnemonic(69);
        createEmail();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("Comments:"));
        $JLabel3.setDisplayedMnemonic(67);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        SwingUtil.setComponentHeight($JScrollPane0,75);
        SwingUtil.setComponentWidth($JScrollPane0,150);
        createComments();
        // inline creation of $JMenuItemDemo0
        setName("$JMenuItemDemo0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    firstName.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_EDITABLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    firstName.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_ENABLED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    lastName.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_EDITABLE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    lastName.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_ENABLED));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    email.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_EDITABLE));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    email.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_ENABLED));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENTS_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    comments.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_EDITABLE));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENTS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    comments.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_ENABLED));
                }
            }
        
            public void $pr$u7(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        addChildrenToMenuBar();
        // inline complete setup of $JMenu0
        $JMenu0.add(enabledCheckBox);
        $JMenu0.add(editableCheckBox);
        addChildrenToFramePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(comments);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 4 property setters
        $JLabel0.setLabelFor(firstName);
        $JLabel1.setLabelFor(lastName);
        $JLabel2.setLabelFor(email);
        $JLabel3.setLabelFor(comments);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
