package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.datetime.JAXXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class DatePickerDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_PATTERN_LAYOUT = "patternLayout";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DATE_PICKER_SHOW_POPUP_BUTTON = "datePicker.showPopupButton";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVlqglR+SQKLRSKSKibIricYYiAo0jZIqRIgh9uK0O2kHtjvjzKxdLhw8ePMf8ODVi+F/IJ5MvHjlfzDhT/DNbNulzbZU2MNuO++9b773zXzvx1+UkgLdZ6JqeT5VzLN2cRBYwvcUrRNrfWVnZ6O8SyoqT2RFUK6YQOGTSKJkCWWd9rpUyCoVAckOkWyNZDeR7DVW58wj3imgpSLKSLXvElkjRCl0t2dxRUp7q525FHBfNPeKZR231+/Pi8cJkv+aRCjgQD8Lbd/7D4Co66EiSlJHoaniLv6IbRd7VSAnqFeFhsb02pqLpXyN6+QDOkDDRZTmWACYQgvnksfAGaiAK5TN5UmdbWKPuA8UetLdggNBq9JCC9eIA3Fh5bEim7SyR4RG4NxgphUa41gpIrwi3mc+sJzUPVi6LyvsK0rNOIBRYKIOFeiayVMkUNYWrXOX5NvBqGJIVyg0bnJ9RV1DI4oP57Zx2SXQylyv05AN4GCZNF002q6dkDXW2GTc56vAm3kKTettgmbF+lqNVPZWWaDTp9tVI7n1Ii4b9aY60s1qZ+5UhzQFSlw4+JmOqm3o3wQ6K41SodoK2d2tNahTJUpaRpyW0aLziSe8qP/f6NpGEOm76i0ljdNRge70UhO8ZEVeiq51ooRSwodlOIneNtZOfANZoQfnentQb2MSPx0eiO+Nk+OW8TJAbvasqlMzBlzABeMgI9XcJkLX6Ztkv8J8qYRGJXFhQJkBNN+f+VYzE9gDiyvRnXyBZQ3QUsPHRz9n3v+5hJIFlHEZdgpY579Eo6oGSteY6wT82XND7nJjBN6TmqZCabdpnvFlOFM8W6aeA9fjaQAqzfdXqU3qcOPk17cvt49aSiWAY26Qykit1DuUpp5LPWKGVHP+xA6lLJfEd1g0XOLGTUJ/M7xp1wXzXozrfyQ8BKLn4nLIYBasI2jZVwRU0IWPTE/612ODe3UA3CE9XnR0+bwYenmlD8L1wREexiPcHKQP7fQ+GLcGwOic0xcE656dF4I7S+PbF9Z4HhD+AYtmWUqtCAAA";
    private static final Log log = LogFactory.getLog(DatePickerDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Date date;
    protected SimpleDateFormat dateFormat;
    protected JAXXDatePicker datePicker;
    protected String patternLayout;
    protected JTextField patternLayoutField;
    protected JLabel resultView;
    protected JCheckBox showPopupButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DatePickerDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
            addPropertyChangeListener(PROPERTY_PATTERN_LAYOUT, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    dateFormat = new SimpleDateFormat(patternLayout);
                    datePicker.setPatternLayout(patternLayout);
                    resultView.setText(dateFormat.format(date));
                }
            });
    
            addPropertyChangeListener(PROPERTY_DATE, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    resultView.setText(dateFormat.format(date));
                }
            });
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DatePickerDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public DatePickerDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public DatePickerDemo(LayoutManager param0) {
        super(param0);
    }

    public DatePickerDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public DatePickerDemo() {
        
    }

    public DatePickerDemo(JAXXContext param0) {
        super(param0);
    }

    public DatePickerDemo(boolean param0) {
        super(param0);
    }

    public DatePickerDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__datePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setDate(datePicker.getDate());
    }

    public void doFocusLost__on__patternLayoutField(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPatternLayout(patternLayoutField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Date getDate() {
        return date;
    }

    public SimpleDateFormat getDateFormat() {
        return dateFormat;
    }

    public JAXXDatePicker getDatePicker() {
        return datePicker;
    }

    public String getPatternLayout() {
        return patternLayout;
    }

    public JTextField getPatternLayoutField() {
        return patternLayoutField;
    }

    public JLabel getResultView() {
        return resultView;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDate(Date date) {
        Date oldValue = this.date;
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public void setPatternLayout(String patternLayout) {
        String oldValue = this.patternLayout;
        this.patternLayout = patternLayout;
        firePropertyChange(PROPERTY_PATTERN_LAYOUT, oldValue, patternLayout);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDate() {
        $objectMap.put("date", date = new Date());
    }

    protected void createDateFormat() {
        $objectMap.put("dateFormat", dateFormat = new SimpleDateFormat(patternLayout));
    }

    protected void createDatePicker() {
        $objectMap.put("datePicker", datePicker = new JAXXDatePicker());
        
        datePicker.setName("datePicker");
        datePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__datePicker"));
    }

    protected void createPatternLayout() {
        $objectMap.put("patternLayout", patternLayout = "dd/MM/yyyy HH:mm:ss");
    }

    protected void createPatternLayoutField() {
        $objectMap.put("patternLayoutField", patternLayoutField = new JTextField());
        
        patternLayoutField.setName("patternLayoutField");
        patternLayoutField.setColumns(15);
        patternLayoutField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__patternLayoutField"));
    }

    protected void createResultView() {
        $objectMap.put("resultView", resultView = new JLabel());
        
        resultView.setName("resultView");
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
        showPopupButton.setSelected(false);
        showPopupButton.setText(t("jaxxdemo.datePickerEditor.showPopupButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createPatternLayout();
        createDateFormat();
        createDate();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createShowPopupButton();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("jaxxdemo.datePickerEditor.patternLayout"));
        createPatternLayoutField();
        createDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("jaxxdemo.datePickerEditor.dateResult"));
        createResultView();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PICKER_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.DatePickerDemo.this, BINDING_DATE_PICKER_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    datePicker.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.DatePickerDemo.this, BINDING_DATE_PICKER_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(showPopupButton, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(patternLayoutField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(datePicker, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultView, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 5 property setters
        SwingUtil.setText(patternLayoutField, patternLayout);
        
        datePicker.setDate(date);
        datePicker.setPatternLayout(patternLayout);
        resultView.setText(dateFormat.format(date));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
