package org.nuiton.jaxx.demo;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box.Filler;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.help.JAXXHelpUI;
import org.nuiton.jaxx.widgets.font.FontSizor;

public class DemoSources extends JPanel implements JAXXHelpUI<DemoHelpBroker>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CURRENT_SOURCE = "currentSource";
    public static final String PROPERTY_INCOMING_CLASS = "incomingClass";
    public static final String PROPERTY_SOURCES = "sources";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_FONT_SIZE = "editor.font-size";
    public static final String BINDING_FONT_SIZOR_FONT_SIZE = "fontSizor.fontSize";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRR+NtiJnaZNKZRSOESJSyu1HYM4IJQKSBqsELm0qiNaEVXtrHeSTJjdmc7M4g2IHjhw6z/QQ69cUP+HihMSF675H5D6J/Bm1/Ha8a9tk8MoO/u9b7739n1v/Od/UDIarkm9S8KIWxmSfRrHREeh5QEjm6v379/29lnbrjPT1lxZqSH9KxShuA1zfm/fWCDbTWSqp0x1x1TvMtVvykDJkIV9RCtNqBp7IJjZY8xauDI2uG1MvdVDrsQq0t2zRqoeddY/v396WGDrz4oAsUL5c5j21dcgyLJ+uwlF7lt4p7lPf6J1QcNdFKd5uIsJzbu9m4Ia8x0N2GN4AjNNKCuqkczC9TcqT0KXUMXKwmxt8w4NmfjEwuJx/T4LJFnHpSUj3WZGqSSubKHsafkj0xaWx8ZsMKHWElQWNs/DtgwwtUSDhTMuPeJSJslOH7IdaZdkerKFhQyZFieDzphUnYXTCSiyXJAmNzaDLDAfFWqX6AajvhP+rsPGxHSQi2xuSSnWqHbwSi+qmhJvUQ+53xvAY309uSZjh7zQCzhVw61agwvBNNbzfH9I9mYwprIjMUv+s0RNHx8vZof7u8wa4jCkcQQcJKhmuVl4f0Blq62lEO7NYGLlNMSmHbvDdxiJONHmILQ0tiy22F+U3G0lz1v4vIrPLramsM2HVB61OdqKZLbKOrywDSUdCfeFlsc72pnyLqJSOy6Pt6M7JgH+9uKJ/qPz6vDIg+dQ3FAPH4/qGzdoCKWlwm7gTtuZ1ICufeq3qFrZhophAmdVMosuT1be6iJRPao4mzXiBjV7yFaaOXz51/lH/74FxQZUhaR+gzr8t1CxexorJoUfq6++TsSd6sziuuBkWig93EMnWfjwlyX8SAHlIek2PLHYtR7VS7/GWLHLkyvWE/ji9qu/nz+99PKoagXUW8sTmVWu9AOUeSh4yJLZ1R1LI2fVnDIs8mU2c0ZNIRjhUNV1bz1ZP5tUmQvDlRFof1cWF/t5kqT77wsYMPVrHHFx+IhU8OhDugbLcUBZ0AMZ4Sw/fcOnli56PPTRu18OsRbcWs3BOO9JjfW7g1otc/fKjfRTLVKLg9OLLBtD/kEO8soOtq6lnki+b+vNicpS0cfRSVlKgfSZcK9vjSb5KAfJbHcCswk8S1N53PaDCelMZ8D7A8dAp9Gn5gRcC20poiBMzfQ9Z50J2V3KwXeO4kRYFZwabM9vQtcC/gSJV3JQzqQSzQlpZp3ZprRkHp7kJr5uJjdCLkHObvc0VScUNIe/lHgQBVN6Mw/VfAflJHfzPZwOU3T9D6GlZxTGCwAA";
    private static final Log log = LogFactory.getLog(DemoSources.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoHelpBroker broker;
    protected String currentSource;
    protected RSyntaxTextArea editor;
    protected JScrollPane editorPane;
    protected JToolBar editorPaneHeader;
    protected FontSizor fontSizor;
    protected DemoSourcesHandler handler;
    protected Class<?> incomingClass;
    protected JComboBox sourceTabs;
    protected List<String> sources;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Filler $Box$Filler0;
    private DemoSources $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        handler.init(this);    
    }
    
    public DemoConfig getConfig() {
        return getContextValue(DemoConfig.class);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoSources(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources() {
        $initialize();
    }

    public DemoSources(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__sourceTabs(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if(event.getStateChange() == ItemEvent.SELECTED) { handler.updateSource(event); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoHelpBroker getBroker() {
        return broker;
    }

    public String getCurrentSource() {
        return currentSource;
    }

    public RSyntaxTextArea getEditor() {
        return editor;
    }

    public JScrollPane getEditorPane() {
        return editorPane;
    }

    public JToolBar getEditorPaneHeader() {
        return editorPaneHeader;
    }

    public FontSizor getFontSizor() {
        return fontSizor;
    }

    public DemoSourcesHandler getHandler() {
        return handler;
    }

    public Class<?> getIncomingClass() {
        return incomingClass;
    }

    public JComboBox getSourceTabs() {
        return sourceTabs;
    }

    public List<String> getSources() {
        return sources;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCurrentSource(String currentSource) {
        String oldValue = this.currentSource;
        this.currentSource = currentSource;
        firePropertyChange(PROPERTY_CURRENT_SOURCE, oldValue, currentSource);
    }

    public void setIncomingClass(Class<?> incomingClass) {
        Class<?> oldValue = this.incomingClass;
        this.incomingClass = incomingClass;
        firePropertyChange(PROPERTY_INCOMING_CLASS, oldValue, incomingClass);
    }

    public void setSources(List<String> sources) {
        List<String> oldValue = this.sources;
        this.sources = sources;
        firePropertyChange(PROPERTY_SOURCES, oldValue, sources);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Filler get$Box$Filler0() {
        return $Box$Filler0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPane() {
        editorPane.getViewport().add(editor);
    }

    protected void addChildrenToEditorPaneHeader() {
        editorPaneHeader.add(sourceTabs);
        editorPaneHeader.add($Box$Filler0);
        editorPaneHeader.add(fontSizor);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new DemoHelpBroker("ui.main.sources"));
    }

    protected void createCurrentSource() {
        $objectMap.put("currentSource", currentSource = null);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new RSyntaxTextArea());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.setAntiAliasingEnabled(true);
        editor.setColumns(80);
        editor.setEditable(false);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(false);
        editor.putClientProperty("help", "ui.main.sources.editor");
    }

    protected void createEditorPane() {
        $objectMap.put("editorPane", editorPane = new JScrollPane());
        
        editorPane.setName("editorPane");
    }

    protected void createEditorPaneHeader() {
        $objectMap.put("editorPaneHeader", editorPaneHeader = new JToolBar());
        
        editorPaneHeader.setName("editorPaneHeader");
        editorPaneHeader.setBorderPainted(false);
        editorPaneHeader.setFloatable(false);
        editorPaneHeader.setOpaque(false);
        editorPaneHeader.putClientProperty("help", "ui.main.sources.toolbar");
    }

    protected void createFontSizor() {
        $objectMap.put("fontSizor", fontSizor = new FontSizor());
        
        fontSizor.setName("fontSizor");
        fontSizor.setOpaque(false);
        fontSizor.setShowFontSize(true);
    }

    protected void createIncomingClass() {
        $objectMap.put("incomingClass", incomingClass = null);
    }

    protected void createSourceTabs() {
        $objectMap.put("sourceTabs", sourceTabs = new JComboBox());
        
        sourceTabs.setName("sourceTabs");
        sourceTabs.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__sourceTabs"));
        sourceTabs.putClientProperty("help", "ui.main.sources.list");
    }

    protected void createSources() {
        $objectMap.put("sources", sources = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        handler = new DemoSourcesHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createBroker();
        createIncomingClass();
        createCurrentSource();
        createSources();
        createEditorPaneHeader();
        createSourceTabs();
        // inline creation of $Box$Filler0
        $objectMap.put("$Box$Filler0", $Box$Filler0 = new Filler(SwingUtil.newMinDimension(), SwingUtil.newMinDimension(), SwingUtil.newMaxXDimension()));
        
        $Box$Filler0.setName("$Box$Filler0");
        createFontSizor();
        createEditorPane();
        createEditor();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FONT_SIZOR_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fontSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    fontSizor.setFontSize(getConfig().getFontSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fontSize", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fontSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    if (editor.getFont() != null) {
                        editor.setFont(editor.getFont().deriveFont((float) getConfig().getFontSize()));
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fontSize", this);
                }
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(editorPaneHeader, BorderLayout.SOUTH);
        add(editorPane, BorderLayout.CENTER);
        addChildrenToEditorPaneHeader();
        addChildrenToEditorPane();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 property setters
        sourceTabs.setModel(new DefaultComboBoxModel());
        editorPane.setColumnHeaderView(editorPaneHeader);
        editor.setMinimumSize(SwingUtil.newMinDimension());// late initializer
        // help broker setup
        DemoHelpBroker _broker = getBroker();
        registerHelpId(_broker, editorPaneHeader, "ui.main.sources.toolbar");
        registerHelpId(_broker, sourceTabs, "ui.main.sources.list");
        registerHelpId(_broker, editor, "ui.main.sources.editor");
        _broker.prepareUI(this);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
