/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.type;

import io.ultreia.java4all.i18n.spi.type.TypeTranslator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeTranslators {
    private static TypeTranslators INSTANCE;
    private final Set<TypeTranslator> translators = ServiceLoader.load(TypeTranslator.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toSet());

    public static TypeTranslators get() {
        return INSTANCE == null ? (INSTANCE = new TypeTranslators()) : INSTANCE;
    }

    public static String getSimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return TypeTranslators.getTranslator(dataType).cleanType(dataType);
    }

    public static TypeTranslator getTranslator(Class<?> type) {
        return TypeTranslators.optionalTranslator(type).orElseThrow(() -> new IllegalStateException("Can't type type translator for type: " + type));
    }

    private static Optional<TypeTranslator> optionalTranslator(Class<?> type) {
        return TypeTranslators.get().getTranslators().stream().filter(t -> t.acceptType(type)).findFirst();
    }

    public Set<TypeTranslator> getTranslators() {
        return this.translators;
    }
}

