/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.type;

import io.ultreia.java4all.i18n.spi.type.TypeTranslator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class SimpleTypeTranslatorSupport
implements TypeTranslator {
    private final String rootPackage;
    private final Class<?> type;
    private final Set<String> suffixes;

    protected SimpleTypeTranslatorSupport(String rootPackage, Class<?> type, String ... suffixes) {
        this.rootPackage = Objects.requireNonNull(rootPackage);
        this.type = Objects.requireNonNull(type);
        this.suffixes = Arrays.stream(suffixes).sorted(Comparator.comparing(String::toString).thenComparingInt(String::length).reversed()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public String getRootPackage() {
        return this.rootPackage;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<String> getSuffixes() {
        return this.suffixes;
    }

    @Override
    public boolean acceptType(Class<?> type) {
        return this.getType().isAssignableFrom(type) && type.getPackageName().startsWith(this.getRootPackage());
    }

    @Override
    public String cleanType(Class<?> type) {
        return this.getRootPackage().equals(type.getPackageName()) ? this.cleanSimpleName(type.getSimpleName()) : this.cleanType(type.getName());
    }

    @Override
    public String cleanType(String fqn) {
        int lastIndex = fqn.lastIndexOf(46);
        return fqn.substring(this.getRootPackage().length() + 1, lastIndex) + "." + this.cleanSimpleName(fqn.substring(lastIndex + 1));
    }

    @Override
    public String cleanSimpleName(String simpleName) {
        for (String suffix : this.getSuffixes()) {
            int i = simpleName.lastIndexOf(suffix);
            if (i == -1) continue;
            simpleName = simpleName.substring(0, i);
        }
        return simpleName;
    }
}

