/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.io;

import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import io.ultreia.java4all.i18n.spi.I18nTranslationSetDefinition;
import io.ultreia.java4all.i18n.spi.io.I18nTranslationSetReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;

public class I18nTranslationSetDirectoryReader
implements I18nTranslationSetReader {
    private final Path directory;
    private final boolean usePackage;

    public I18nTranslationSetDirectoryReader(Path directory, boolean usePackage) {
        this.directory = Objects.requireNonNull(directory);
        this.usePackage = usePackage;
    }

    @Override
    public boolean isUsePackage() {
        return this.usePackage;
    }

    @Override
    public Properties read(I18nTranslationSetDefinition definition, Charset encoding) throws I18nResourceInitializationException {
        String fileName = definition.getResourcePath(this.usePackage);
        Path file = this.directory.resolve(fileName);
        Properties result = new Properties();
        if (Files.exists(file, new LinkOption[0])) {
            try {
                try (BufferedReader reader = Files.newBufferedReader(file, encoding);){
                    result.load(reader);
                }
                return result;
            }
            catch (IOException e) {
                throw new I18nResourceInitializationException("Can't read translations from file: " + file, e);
            }
        }
        return result;
    }
}

