/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.io;

import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import io.ultreia.java4all.i18n.spi.I18nTranslationSetDefinition;
import io.ultreia.java4all.i18n.spi.io.I18nTranslationSetReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Properties;

public class I18nTranslationSetClassPathReader
implements I18nTranslationSetReader {
    private final ClassLoader classLoader;
    private final boolean usePackage;

    public I18nTranslationSetClassPathReader(ClassLoader classLoader, boolean usePackage) {
        this.classLoader = Objects.requireNonNull(classLoader);
        this.usePackage = usePackage;
    }

    @Override
    public boolean isUsePackage() {
        return this.usePackage;
    }

    @Override
    public Properties read(I18nTranslationSetDefinition definition, Charset encoding) throws I18nResourceInitializationException {
        String path = "META-INF/i18n/translations/" + definition.getResourcePath(this.usePackage);
        URL resource = Objects.requireNonNull(this.classLoader).getResource((String)((Object)Objects.requireNonNull(path)));
        Properties result = new Properties();
        if (resource == null) {
            throw new I18nResourceInitializationException("Could not find resource: " + path);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), encoding));){
            result.load(reader);
        }
        catch (IOException e) {
            throw new I18nResourceInitializationException("Could not load resource: " + path, e);
        }
        return result;
    }
}

