/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.io;

import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import io.ultreia.java4all.i18n.spi.I18nTemplateDefinition;
import io.ultreia.java4all.i18n.spi.io.I18nTemplateReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public class I18nTemplateDirectoryReader
implements I18nTemplateReader {
    private final Path directory;
    private final boolean usePackage;

    public I18nTemplateDirectoryReader(Path directory, boolean usePackage) {
        this.directory = Objects.requireNonNull(directory);
        this.usePackage = usePackage;
    }

    @Override
    public boolean isUsePackage() {
        return this.usePackage;
    }

    @Override
    public String read(I18nTemplateDefinition definition, Charset encoding) throws I18nResourceInitializationException {
        String fileName = definition.getResourcePath(this.usePackage);
        Path file = this.directory.resolve(fileName);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return String.join((CharSequence)"\n", Files.readAllLines(file, encoding));
            }
            catch (IOException e) {
                throw new I18nResourceInitializationException("Can't load templates from file: " + file, e);
            }
        }
        return null;
    }
}

