/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.io;

import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import io.ultreia.java4all.i18n.spi.I18nTemplateDefinition;
import io.ultreia.java4all.i18n.spi.io.I18nTemplateReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;

public class I18nTemplateClassPathReader
implements I18nTemplateReader {
    private final ClassLoader classLoader;
    private final boolean usePackage;

    public I18nTemplateClassPathReader(ClassLoader classLoader, boolean usePackage) {
        this.classLoader = Objects.requireNonNull(classLoader);
        this.usePackage = usePackage;
    }

    @Override
    public boolean isUsePackage() {
        return this.usePackage;
    }

    @Override
    public String read(I18nTemplateDefinition definition, Charset encoding) throws I18nResourceInitializationException {
        String path = "META-INF/i18n/templates/" + definition.getResourcePath(this.usePackage);
        URL resource = Objects.requireNonNull(this.classLoader).getResource((String)((Object)Objects.requireNonNull(path)));
        StringBuilder result = new StringBuilder();
        if (resource == null) {
            throw new I18nResourceInitializationException("Could not find resource: " + path);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new I18nResourceInitializationException("Could not load resource: " + path, e);
        }
        return result.toString();
    }
}

