/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.io;

import io.ultreia.java4all.i18n.spi.I18nKeySetDefinition;
import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import io.ultreia.java4all.i18n.spi.io.I18nKeySetReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class I18nKeySetDirectoryReader
implements I18nKeySetReader {
    private final Path directory;
    private final boolean usePackage;

    public I18nKeySetDirectoryReader(Path directory, boolean usePackage) {
        this.directory = Objects.requireNonNull(directory);
        this.usePackage = usePackage;
    }

    @Override
    public boolean isUsePackage() {
        return this.usePackage;
    }

    @Override
    public Set<String> read(I18nKeySetDefinition definition) throws I18nResourceInitializationException {
        String fileName = definition.getResourcePath(this.usePackage);
        Path file = this.directory.resolve(fileName);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                List<String> keys = Files.readAllLines(file, StandardCharsets.UTF_8);
                return new TreeSet<String>(keys);
            }
            catch (IOException e) {
                throw new I18nResourceInitializationException("Can't load keySet from file: " + file, e);
            }
        }
        return new TreeSet<String>();
    }
}

