/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.io;

import io.ultreia.java4all.i18n.spi.I18nKeySetDefinition;
import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import io.ultreia.java4all.i18n.spi.I18nResourceNotFoundException;
import io.ultreia.java4all.i18n.spi.io.I18nKeySetReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class I18nKeySetClassPathReader
implements I18nKeySetReader {
    private final ClassLoader classLoader;
    private final boolean usePackage;

    public I18nKeySetClassPathReader(ClassLoader classLoader, boolean usePackage) {
        this.classLoader = Objects.requireNonNull(classLoader);
        this.usePackage = usePackage;
    }

    @Override
    public boolean isUsePackage() {
        return this.usePackage;
    }

    @Override
    public Set<String> read(I18nKeySetDefinition definition) throws I18nResourceInitializationException {
        String path = "META-INF/i18n/getters/" + definition.getResourcePath(this.usePackage);
        TreeSet<String> keys = new TreeSet<String>();
        try {
            URL resource = Objects.requireNonNull(this.classLoader).getResource((String)((Object)Objects.requireNonNull(path)));
            if (resource == null) {
                throw new I18nResourceNotFoundException("Could not find resource: " + path);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    keys.add(line);
                }
            }
        }
        catch (I18nResourceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new I18nResourceInitializationException("Could not load keys from classpath: " + path, e);
        }
        return keys;
    }
}

