/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.bean;

import io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducerSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class DefaultBeanPropertyI18nKeyProducer
extends BeanPropertyI18nKeyProducerSupport {
    private final String labelsLocation;

    public DefaultBeanPropertyI18nKeyProducer(String i18nPrefix, String labelsLocation) {
        super(i18nPrefix);
        this.labelsLocation = labelsLocation;
    }

    @Override
    protected Map<String, String> createMapping() {
        URL resource = this.getClass().getClassLoader().getResource(this.labelsLocation);
        TreeMap<String, String> result = new TreeMap<String, String>();
        try (InputStream inputStream = Objects.requireNonNull(resource, String.format("Can't find resource: %s", this.labelsLocation)).openStream();){
            Properties p = new Properties();
            p.load(inputStream);
            p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.put(key.toString(), value.toString())));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Can't load resource: %s", this.labelsLocation), e);
        }
        return result;
    }
}

