/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi.bean;

import io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducer;
import java.util.Collections;
import java.util.Map;

public class BeanPropertyI18nKeyProducerSupport
implements BeanPropertyI18nKeyProducer {
    private final String i18nPrefix;
    private final Map<String, String> mapping;
    private final Map<String, String> propertyMapping;

    protected BeanPropertyI18nKeyProducerSupport(String i18nPrefix) {
        this.i18nPrefix = i18nPrefix;
        this.mapping = this.createMapping();
        this.propertyMapping = this.createPropertyKeyMapping();
    }

    @Override
    public String getCommonPrefix() {
        return this.i18nPrefix;
    }

    @Override
    public String getI18nPropertyKey(Class<?> type, String property) {
        String propertyMapping = this.getPropertyMapping(property);
        String typeKey = this.getPropertyTypeMapping(type, propertyMapping);
        return this.i18nPrefix + typeKey + propertyMapping;
    }

    @Override
    public String getPropertyMapping(String property) {
        return this.propertyMapping.getOrDefault(property, property);
    }

    @Override
    public String getI18nTypeKey(Class<?> type) {
        return type.getSimpleName();
    }

    protected Map<String, String> createMapping() {
        return Collections.emptyMap();
    }

    protected Map<String, String> createPropertyKeyMapping() {
        return Collections.emptyMap();
    }

    protected String getPropertyTypeMapping(Class<?> type, String property) {
        return this.mapping.getOrDefault(property, this.getI18nTypeKey(type) + ".");
    }
}

