/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import io.ultreia.java4all.i18n.spi.I18nLocaleHelper;
import io.ultreia.java4all.i18n.spi.I18nLocalizedResource;
import io.ultreia.java4all.i18n.spi.I18nProperties;
import io.ultreia.java4all.i18n.spi.I18nResource;
import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class I18nTranslationSetDefinition
extends I18nLocalizedResource {
    public static final String TRANSLATION_SET_EXTENSION = ".properties";
    public static final String PATH = "translations";
    public static final String I18N_CLASS_PATH = "META-INF/i18n/translations";
    private static final Logger log = LogManager.getLogger(I18nTranslationSetDefinition.class);

    public I18nTranslationSetDefinition(String packageName, String name, Locale locale) {
        super(packageName, name, TRANSLATION_SET_EXTENSION, locale);
    }

    public static List<I18nTranslationSetDefinition> translationSetListFromCoordinate(String coordinate) {
        LinkedList<I18nTranslationSetDefinition> result = new LinkedList<I18nTranslationSetDefinition>();
        String[] tokenizer = coordinate.split("__");
        String packageName = tokenizer[0];
        String name = tokenizer[1];
        for (int i = 2; i < tokenizer.length; ++i) {
            String locale = tokenizer[i];
            result.add(new I18nTranslationSetDefinition(packageName, name, I18nLocaleHelper.newLocale(locale)));
        }
        return result;
    }

    public static I18nTranslationSetDefinition translationSetFromFilename(String packageName, Path coordinate) {
        String filename = I18nResource.removeExtension(Objects.requireNonNull(coordinate).toFile().getName(), TRANSLATION_SET_EXTENSION);
        int i = filename.indexOf("_");
        String name = filename.substring(0, i);
        String localeStr = filename.substring(i + 1);
        return new I18nTranslationSetDefinition(packageName, name, I18nLocaleHelper.newLocale(localeStr));
    }

    public static Path write(I18nTranslationSetDefinition definition, Charset encoding, boolean usePackage, Path directory, Properties properties, boolean override) throws IOException {
        if (!Files.exists(Objects.requireNonNull(directory), new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        String fileName = definition.getResourcePath(usePackage);
        Path target = directory.resolve(fileName);
        if (override || !Files.exists(target, new LinkOption[0])) {
            I18nProperties p = properties instanceof I18nProperties ? (I18nProperties)properties : new I18nProperties(encoding.name(), true);
            p.putAll((Map<?, ?>)properties);
            log.info("Store translations " + definition.getId() + " to " + target);
            p.store(target.toFile());
        }
        return target;
    }

    public static List<I18nTranslationSetDefinition> detect(Path directory, String packageName) throws I18nResourceInitializationException {
        if (!Files.exists(directory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.walk(directory, 1, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toFile().getName().endsWith(TRANSLATION_SET_EXTENSION)).map(f -> I18nTranslationSetDefinition.translationSetFromFilename(packageName, f)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new I18nResourceInitializationException("Could not init from: " + directory, e);
        }
    }
}

