/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import io.ultreia.java4all.i18n.spi.I18nLocaleHelper;
import io.ultreia.java4all.i18n.spi.I18nLocalizedResource;
import io.ultreia.java4all.i18n.spi.I18nResource;
import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class I18nTemplateDefinition
extends I18nLocalizedResource {
    private static final Logger log = LogManager.getLogger(I18nTemplateDefinition.class);
    public static final String DEFAULT_TEMPLATE_SET_EXTENSION = ".ftl";
    public static final String PATH = "templates";
    public static final String I18N_CLASS_PATH = "META-INF/i18n/templates";

    public I18nTemplateDefinition(String packageName, String name, String templateExtension, Locale locale) {
        super(packageName, name, templateExtension, locale);
    }

    public static List<I18nTemplateDefinition> detect(Path directory, String packageName, String templateExtension) throws I18nResourceInitializationException {
        if (!Files.exists(directory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.walk(directory, 1, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toFile().getName().endsWith(templateExtension)).map(f -> I18nTemplateDefinition.templateFromFilename(packageName, templateExtension, f)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new I18nResourceInitializationException("Could not init from: " + directory, e);
        }
    }

    public static Path write(I18nTemplateDefinition definition, Path directory, Charset encoding, boolean usePackage, String template, boolean override) throws IOException {
        if (!Files.exists(Objects.requireNonNull(directory), new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        String fileName = definition.getResourcePath(usePackage);
        Path target = directory.resolve(fileName);
        if (override || !Files.exists(target, new LinkOption[0])) {
            log.info("Store template " + definition.getId() + " to " + target);
            Files.write(target, Collections.singletonList(template), encoding, new OpenOption[0]);
        }
        return target;
    }

    public static List<I18nTemplateDefinition> templateListFromCoordinate(String templateExtension, String coordinate) {
        LinkedList<I18nTemplateDefinition> result = new LinkedList<I18nTemplateDefinition>();
        String[] tokenizer = coordinate.split("__");
        String packageName = tokenizer[0];
        String name = tokenizer[1];
        for (int i = 2; i < tokenizer.length; ++i) {
            String locale = tokenizer[i];
            result.add(new I18nTemplateDefinition(packageName, name, templateExtension, I18nLocaleHelper.newLocale(locale)));
        }
        return result;
    }

    public static I18nTemplateDefinition templateFromFilename(String packageName, String templateExtension, Path coordinate) {
        String filename = I18nResource.removeExtension(Objects.requireNonNull(coordinate).toFile().getName(), templateExtension);
        int i = filename.indexOf("_");
        String name = filename.substring(0, i);
        String localeStr = filename.substring(i + 1);
        return new I18nTemplateDefinition(packageName, name, templateExtension, I18nLocaleHelper.newLocale(localeStr));
    }
}

