/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import io.ultreia.java4all.i18n.spi.I18nCoordinate;
import java.util.Objects;

public class I18nResource
extends I18nCoordinate {
    protected static final String I18N_CLASS_PATH = "META-INF/i18n";
    private final String extension;

    public I18nResource(I18nCoordinate coordinate, String extension) {
        this(Objects.requireNonNull(coordinate).getPackageName(), coordinate.getName(), extension);
    }

    public I18nResource(String packageName, String name, String extension) {
        super(Objects.requireNonNull(packageName), I18nResource.removeExtension(Objects.requireNonNull(name), Objects.requireNonNull(extension)));
        this.extension = extension;
    }

    public static String removeExtension(String name, String extension) {
        if (name.endsWith(extension)) {
            name = name.substring(0, name.length() - extension.length());
        }
        return name;
    }

    public String getResourcePath(boolean usePackage) {
        return this.getResourcePathPrefix(usePackage) + this.getName() + this.getExtension();
    }

    public String getExtension() {
        return this.extension;
    }
}

