/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import io.ultreia.java4all.i18n.spi.I18nCoordinate;
import io.ultreia.java4all.i18n.spi.I18nKeySetDefinition;
import io.ultreia.java4all.i18n.spi.I18nLocalizedResource;
import io.ultreia.java4all.i18n.spi.I18nTemplateDefinition;
import io.ultreia.java4all.i18n.spi.I18nTranslationSetDefinition;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public class I18nModuleDefinition
extends I18nCoordinate {
    private final List<I18nKeySetDefinition> moduleKeySetDefinitions;
    private final List<I18nKeySetDefinition> dependenciesKeySetDefinitions;
    private final List<I18nTranslationSetDefinition> moduleTranslationSetDefinitions;
    private final List<I18nTranslationSetDefinition> dependenciesTranslationSetDefinitions;
    private final List<I18nTemplateDefinition> moduleTemplateSetDefinitions;
    private final List<I18nTemplateDefinition> dependenciesTemplateSetDefinitions;
    private final String templateExtension;

    public I18nModuleDefinition(String packageName, String moduleName, String[] moduleGetters, String[] dependenciesGetters, String[] moduleTranslations, String[] dependenciesTranslations, String[] moduleTemplates, String[] dependenciesTemplates) {
        this(packageName, moduleName, ".ftl", moduleGetters, dependenciesGetters, moduleTranslations, dependenciesTranslations, moduleTemplates, dependenciesTemplates);
    }

    public I18nModuleDefinition(String packageName, String moduleName, String templateExtension, String[] moduleGetters, String[] dependenciesGetters, String[] moduleTranslations, String[] dependenciesTranslations, String[] moduleTemplates, String[] dependenciesTemplates) {
        super(packageName, moduleName);
        this.templateExtension = templateExtension;
        this.moduleKeySetDefinitions = new LinkedList<I18nKeySetDefinition>();
        this.dependenciesKeySetDefinitions = new LinkedList<I18nKeySetDefinition>();
        this.moduleTranslationSetDefinitions = new LinkedList<I18nTranslationSetDefinition>();
        this.dependenciesTranslationSetDefinitions = new LinkedList<I18nTranslationSetDefinition>();
        this.moduleTemplateSetDefinitions = new LinkedList<I18nTemplateDefinition>();
        this.dependenciesTemplateSetDefinitions = new LinkedList<I18nTemplateDefinition>();
        Arrays.stream(moduleGetters).map(I18nKeySetDefinition::newKey).forEachOrdered(this.moduleKeySetDefinitions::add);
        Arrays.stream(dependenciesGetters).map(I18nKeySetDefinition::newKey).forEachOrdered(this.dependenciesKeySetDefinitions::add);
        Arrays.stream(moduleTranslations).map(I18nTranslationSetDefinition::translationSetListFromCoordinate).forEachOrdered(this.moduleTranslationSetDefinitions::addAll);
        Arrays.stream(dependenciesTranslations).map(I18nTranslationSetDefinition::translationSetListFromCoordinate).forEachOrdered(this.dependenciesTranslationSetDefinitions::addAll);
        Arrays.stream(moduleTemplates).map(f -> I18nTemplateDefinition.templateListFromCoordinate(templateExtension, f)).forEachOrdered(this.moduleTemplateSetDefinitions::addAll);
        Arrays.stream(dependenciesTemplates).map(f -> I18nTemplateDefinition.templateListFromCoordinate(templateExtension, f)).forEachOrdered(this.dependenciesTemplateSetDefinitions::addAll);
    }

    public static List<I18nModuleDefinition> detect(ClassLoader classLoader) {
        LinkedList<I18nModuleDefinition> result = new LinkedList<I18nModuleDefinition>();
        for (I18nModuleDefinition i18nModuleDefinition : ServiceLoader.load(I18nModuleDefinition.class, classLoader)) {
            result.add(i18nModuleDefinition);
        }
        return result;
    }

    public String getTemplateExtension() {
        return this.templateExtension;
    }

    public boolean isContainsModuleKeySets() {
        return !this.moduleKeySetDefinitions.isEmpty();
    }

    public boolean isContainsDependenciesKeySets() {
        return !this.dependenciesKeySetDefinitions.isEmpty();
    }

    public boolean isContainsModuleTemplateSets() {
        return !this.moduleTemplateSetDefinitions.isEmpty();
    }

    public boolean isContainsDependenciesTemplateSets() {
        return !this.dependenciesTemplateSetDefinitions.isEmpty();
    }

    public boolean isContainsModuleTranslationSets() {
        return !this.moduleTranslationSetDefinitions.isEmpty();
    }

    public boolean isContainsDependenciesTranslationSets() {
        return !this.dependenciesTranslationSetDefinitions.isEmpty();
    }

    public List<I18nKeySetDefinition> getModuleKeySetDefinitions() {
        return this.moduleKeySetDefinitions;
    }

    public List<I18nKeySetDefinition> getDependenciesKeySetDefinitions() {
        return this.dependenciesKeySetDefinitions;
    }

    public List<I18nTranslationSetDefinition> getModuleTranslationSetDefinitions() {
        return this.moduleTranslationSetDefinitions;
    }

    public Set<Locale> getModuleTranslationSetLocales() {
        return this.moduleTranslationSetDefinitions.stream().map(I18nLocalizedResource::getLocale).collect(Collectors.toSet());
    }

    public List<I18nTranslationSetDefinition> getDependenciesTranslationSetDefinitions() {
        return this.dependenciesTranslationSetDefinitions;
    }

    public List<I18nTemplateDefinition> getModuleTemplateSetDefinitions() {
        return this.moduleTemplateSetDefinitions;
    }

    public List<I18nTemplateDefinition> getDependenciesTemplateSetDefinitions() {
        return this.dependenciesTemplateSetDefinitions;
    }

    public String toString() {
        String moduleKeySetDefinitions = this.getModuleKeySetDefinitions().stream().map(I18nCoordinate::getId).collect(Collectors.joining(" "));
        String dependenciesKeySetDefinitions = this.getDependenciesKeySetDefinitions().stream().map(I18nCoordinate::getId).collect(Collectors.joining(" "));
        String moduleTemplateSetDefinitions = this.getModuleTemplateSetDefinitions().stream().map(I18nCoordinate::getId).collect(Collectors.joining(" "));
        String dependenciesTemplateSetDefinitions = this.getDependenciesTemplateSetDefinitions().stream().map(I18nCoordinate::getId).collect(Collectors.joining(" "));
        String moduleTranslationDefinitions = this.getModuleTranslationSetDefinitions().stream().map(I18nCoordinate::getId).map(Object::toString).collect(Collectors.joining(" "));
        String dependenciesTranslationDefinitions = this.getDependenciesTranslationSetDefinitions().stream().map(I18nCoordinate::getId).map(Object::toString).collect(Collectors.joining(" "));
        return "I18nModuleDefinition{moduleId='" + this.getId() + "'" + (String)(moduleKeySetDefinitions.isEmpty() ? "" : "module.keySets='" + moduleKeySetDefinitions + "'") + (String)(dependenciesKeySetDefinitions.isEmpty() ? "" : "dependencies.keySets='" + dependenciesKeySetDefinitions + "'") + (String)(moduleTranslationDefinitions.isEmpty() ? "" : "module.translation='" + moduleTranslationDefinitions + "'") + (String)(dependenciesTranslationDefinitions.isEmpty() ? "" : "dependencies.translation='" + dependenciesTranslationDefinitions + "'") + (String)(moduleTemplateSetDefinitions.isEmpty() ? "" : "module.templateSets='" + moduleTemplateSetDefinitions + "'") + (String)(dependenciesTemplateSetDefinitions.isEmpty() ? "" : "dependencies.templateSets='" + dependenciesTemplateSetDefinitions + "'") + "}";
    }

    public Set<I18nTranslationSetDefinition> getModuleTranslationSetDefinitions(Locale locale) {
        return this.moduleTranslationSetDefinitions.stream().filter(d -> locale.equals(d.getLocale())).collect(Collectors.toSet());
    }

    public Set<I18nTemplateDefinition> getModuleTemplateSetDefinitions(Locale locale) {
        return this.moduleTemplateSetDefinitions.stream().filter(d -> locale.equals(d.getLocale())).collect(Collectors.toSet());
    }
}

