/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.converter.LocaleConverter;

public class I18nLocaleHelper {
    public static final LocaleConverter LOCALE_CONVERTER = new LocaleConverter();
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    private static final Logger log = LogManager.getLogger(I18nLocaleHelper.class);

    public static Set<Locale> parseLocalesAsSet(String str) throws IllegalArgumentException {
        return new LinkedHashSet<Locale>(Arrays.asList(I18nLocaleHelper.parseLocales(str)));
    }

    public static Locale[] parseLocales(String str) throws IllegalArgumentException {
        String[] bundlesToUse;
        ArrayList<Locale> result = new ArrayList<Locale>();
        for (String aBundlesToUse : bundlesToUse = str.split(",")) {
            String s = aBundlesToUse.trim();
            try {
                Locale l = LOCALE_CONVERTER.valueOf(s);
                result.add(l);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("bundle %s is not a valid locale", s), e);
            }
        }
        return result.toArray(new Locale[0]);
    }

    public static Locale newLocale(String str) {
        if (str == null) {
            return I18nLocaleHelper.newLocale(null, null);
        }
        try {
            return LOCALE_CONVERTER.valueOf(str);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn(String.format("could not load locale '%s for reason : %s", str, e.getMessage()));
            }
            return DEFAULT_LOCALE;
        }
    }

    public static Locale newLocale(String language, String country) {
        if (language == null) {
            language = System.getProperty("user.language", DEFAULT_LOCALE.getLanguage());
            country = System.getProperty("user.country", DEFAULT_LOCALE.getCountry());
        }
        return I18nLocaleHelper.newLocale(language + (String)(country == null ? "" : "_" + country));
    }
}

