/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import io.ultreia.java4all.i18n.spi.I18nCoordinate;
import io.ultreia.java4all.i18n.spi.I18nResource;
import io.ultreia.java4all.i18n.spi.I18nResourceInitializationException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class I18nKeySetDefinition
extends I18nResource {
    public static final String PATH = "getters";
    public static final String I18N_CLASS_PATH = "META-INF/i18n/getters";
    public static String KEY_SET_EXTENSION = ".getter";

    public I18nKeySetDefinition(String packageName, String name) {
        super(packageName, name, KEY_SET_EXTENSION);
    }

    public I18nKeySetDefinition(I18nCoordinate coordinate) {
        super(coordinate, KEY_SET_EXTENSION);
    }

    public static I18nKeySetDefinition newKey(String coordinate) {
        String[] split = Objects.requireNonNull(coordinate).split("__");
        return new I18nKeySetDefinition(split[0], split[1]);
    }

    public static I18nKeySetDefinition newKeyFromPath(String packageName, Path coordinate) {
        return I18nKeySetDefinition.newKey(packageName + "__" + I18nKeySetDefinition.removeExtension(coordinate.toFile().getName(), KEY_SET_EXTENSION));
    }

    public static List<I18nKeySetDefinition> detect(Path directory, String packageName) throws I18nResourceInitializationException {
        if (!Files.exists(directory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        String extension = KEY_SET_EXTENSION;
        try {
            return Files.walk(directory, 1, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toFile().getName().endsWith(extension)).map(f -> I18nKeySetDefinition.newKeyFromPath(packageName, f)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new I18nResourceInitializationException("Can't detect key sets from directory: " + directory, e);
        }
    }

    public static Path write(I18nKeySetDefinition definition, Path directory, Charset encoding, boolean usePackage, Set<String> keys) throws IOException {
        if (!Files.exists(Objects.requireNonNull(directory), new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        String fileName = definition.getResourcePath(usePackage);
        Path target = directory.resolve(fileName);
        Files.write(target, keys, encoding, new OpenOption[0]);
        return target;
    }
}

