/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import java.util.Objects;

public class I18nCoordinate {
    public static final String GROUP_ID_SEPARATOR = "__";
    private final String packageName;
    private final String name;

    public I18nCoordinate(I18nCoordinate coordinate) {
        this(coordinate.getPackageName(), coordinate.getName());
    }

    public I18nCoordinate(String packageName, String name) {
        this.packageName = Objects.requireNonNull(packageName);
        this.name = Objects.requireNonNull(name);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.getId(this.getName());
    }

    public String getId(String name) {
        return this.getResourcePathPrefix(true) + name;
    }

    public String getResourcePathPrefix(boolean usePackage) {
        return usePackage ? this.getPackageName() + GROUP_ID_SEPARATOR : "";
    }
}

