/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.i18n.spi;

import io.ultreia.java4all.i18n.spi.I18nCoordinate;
import io.ultreia.java4all.i18n.spi.I18nLocaleHelper;
import io.ultreia.java4all.i18n.spi.I18nModuleDefinition;
import io.ultreia.java4all.i18n.spi.I18nTemplateDefinition;
import io.ultreia.java4all.i18n.spi.I18nTranslationSetDefinition;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public class I18nApplicationDefinition
extends I18nCoordinate {
    private final Charset encoding;
    private final String version;
    private final List<Locale> locales;
    private final Map<String, String> keyCategories;
    private final List<I18nTranslationSetDefinition> applicationTranslationDefinitions;
    private final List<I18nTranslationSetDefinition> dependenciesTranslationDefinitions;
    private final List<I18nTemplateDefinition> applicationTemplateDefinitions;
    private final String templateExtension;

    public I18nApplicationDefinition(String packageName, String name, Charset encoding, String version, String[] locales, Map<String, String> keyCategories, String[] moduleTranslations, String[] dependenciesTranslations, String[] applicationTemplates) {
        this(packageName, name, ".ftl", encoding, version, locales, keyCategories, moduleTranslations, dependenciesTranslations, applicationTemplates);
    }

    public I18nApplicationDefinition(String packageName, String name, String templateExtension, Charset encoding, String version, String[] locales, Map<String, String> keyCategories, String[] moduleTranslations, String[] dependenciesTranslations, String[] applicationTemplates) {
        super(packageName, name);
        this.templateExtension = templateExtension;
        this.encoding = encoding;
        this.version = version;
        this.locales = Collections.unmodifiableList(Arrays.stream(locales).map(I18nLocaleHelper::newLocale).collect(Collectors.toList()));
        this.keyCategories = keyCategories;
        this.applicationTranslationDefinitions = new LinkedList<I18nTranslationSetDefinition>();
        this.dependenciesTranslationDefinitions = new LinkedList<I18nTranslationSetDefinition>();
        this.applicationTemplateDefinitions = new LinkedList<I18nTemplateDefinition>();
        Arrays.stream(moduleTranslations).map(I18nTranslationSetDefinition::translationSetListFromCoordinate).forEachOrdered(this.applicationTranslationDefinitions::addAll);
        Arrays.stream(dependenciesTranslations).map(I18nTranslationSetDefinition::translationSetListFromCoordinate).forEachOrdered(this.dependenciesTranslationDefinitions::addAll);
        Arrays.stream(applicationTemplates).map(f -> I18nTemplateDefinition.templateListFromCoordinate(templateExtension, f)).forEachOrdered(this.applicationTemplateDefinitions::addAll);
    }

    public I18nApplicationDefinition(String packageName, String name, Charset encoding, String version, List<I18nModuleDefinition> moduleDefinitions, Map<String, String> keyCategories) {
        this(packageName, name, ".ftl", encoding, version, moduleDefinitions, keyCategories);
    }

    public I18nApplicationDefinition(String packageName, String name, String templateExtension, Charset encoding, String version, List<I18nModuleDefinition> moduleDefinitions, Map<String, String> keyCategories) {
        super(packageName, name);
        this.templateExtension = templateExtension;
        this.encoding = encoding;
        this.version = version;
        LinkedList<I18nTranslationSetDefinition> translationSets = new LinkedList<I18nTranslationSetDefinition>();
        LinkedList<I18nTemplateDefinition> templates = new LinkedList<I18nTemplateDefinition>();
        LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>();
        for (I18nModuleDefinition i18nModuleDefinition : moduleDefinitions) {
            for (I18nTranslationSetDefinition moduleTranslationSetDefinition : i18nModuleDefinition.getModuleTranslationSetDefinitions()) {
                locales.add(moduleTranslationSetDefinition.getLocale());
            }
            translationSets.addAll(i18nModuleDefinition.getModuleTranslationSetDefinitions());
            templates.addAll(i18nModuleDefinition.getModuleTemplateSetDefinitions());
        }
        this.locales = Collections.unmodifiableList(new LinkedList(locales));
        this.keyCategories = keyCategories;
        this.applicationTranslationDefinitions = new LinkedList<I18nTranslationSetDefinition>();
        this.dependenciesTranslationDefinitions = new LinkedList<I18nTranslationSetDefinition>(translationSets);
        this.applicationTemplateDefinitions = new LinkedList<I18nTemplateDefinition>(templates);
    }

    public static Optional<I18nApplicationDefinition> detect(ClassLoader classLoader) {
        LinkedList<I18nApplicationDefinition> result = new LinkedList<I18nApplicationDefinition>();
        for (I18nApplicationDefinition i18nModuleDefinition : ServiceLoader.load(I18nApplicationDefinition.class, classLoader)) {
            result.add(i18nModuleDefinition);
        }
        if (result.size() == 1) {
            return Optional.of((I18nApplicationDefinition)result.get(0));
        }
        return Optional.empty();
    }

    public String getTemplateExtension() {
        return this.templateExtension;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public List<I18nTranslationSetDefinition> getApplicationTranslationDefinitions() {
        return this.applicationTranslationDefinitions;
    }

    public List<I18nTranslationSetDefinition> getDependenciesTranslationDefinitions() {
        return this.dependenciesTranslationDefinitions;
    }

    public List<I18nTemplateDefinition> getApplicationTemplateDefinitions() {
        return this.applicationTemplateDefinitions;
    }

    public Set<String> getTemplateList() {
        return this.applicationTemplateDefinitions.stream().map(I18nCoordinate::getName).collect(Collectors.toSet());
    }

    public Map<String, String> getKeyCategories() {
        return this.keyCategories;
    }
}

