/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import io.ultreia.java4all.lang.ClassLoaders;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.FasterCachedResourceResolver;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ResourceResolver;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.WriterReport;
import org.nuiton.plugin.PluginHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component(role=ChainedFileWriter.class, hint="xmi")
public class XmiChainedFileWriter
extends BaseChainedFileWriter {
    public static final String PROP_RESOLVER = "resolver";
    public static final String PROP_FULL_PACKAGE_PATH = "fullPackagePath";
    public static final String PROP_EXTRACTED_PACKAGES = "extraPackages";
    protected TransformerFactory transformerFactory;

    public XmiChainedFileWriter() {
        super(PROP_RESOLVER, PROP_RESOLVER, PROP_FULL_PACKAGE_PATH, PROP_FULL_PACKAGE_PATH, PROP_EXTRACTED_PACKAGES, PROP_EXTRACTED_PACKAGES);
    }

    public boolean acceptModel(String modelType) {
        return this.acceptObjectModelOrStateModel(modelType);
    }

    public String getInputProtocol() {
        return "xmi";
    }

    public String getOutputProtocol(String modelType) {
        return "model";
    }

    public boolean acceptInclude(String include) {
        return include.startsWith("xmi:") || include.endsWith(".xmi") || include.endsWith(".uml");
    }

    public String getDefaultIncludes() {
        return "**/*.xmi";
    }

    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    public String getDefaultOutputDirectory() {
        return "models";
    }

    public String getDefaultTestInputDirectory() {
        return "src/test/xmi";
    }

    public String getDefaultTestOutputDirectory() {
        return "test-models";
    }

    protected TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    public String getFullPackagePath() {
        return (String)this.getProperty(PROP_FULL_PACKAGE_PATH, String.class);
    }

    public String getExtractedPackages() {
        return (String)this.getProperty(PROP_EXTRACTED_PACKAGES, String.class);
    }

    public String getResolver() {
        return (String)this.getProperty(PROP_RESOLVER, String.class);
    }

    public void generate(ChainedFileWriterConfiguration configuration, File outputDirectory, Map<File, List<File>> filesByRoot, Map<File, List<File>> resourcesByFile) throws IOException {
        if (configuration.isVerbose()) {
            this.getLog().info((CharSequence)(" with fullPackagePath   : " + this.getFullPackagePath()));
            this.getLog().info((CharSequence)(" with resolver          : " + this.getResolver()));
        }
        for (Map.Entry<File, List<File>> entry : filesByRoot.entrySet()) {
            File inputDirectory = entry.getKey();
            List<File> files = entry.getValue();
            if (configuration.isVerbose()) {
                this.getLog().info((CharSequence)("Processing XSL tranformation on " + inputDirectory + " for " + files.size() + " file(s)."));
            }
            for (File file : files) {
                this.actionXsl(configuration, outputDirectory, inputDirectory, file);
                this.copyResources(configuration, outputDirectory, inputDirectory, file, resourcesByFile);
            }
        }
    }

    protected boolean actionXsl(ChainedFileWriterConfiguration configuration, File outputDirectory, File inputDirectory, File file) throws IOException {
        try {
            this.getLog().debug((CharSequence)("treat file : " + file));
            URIResolver fileResolver = this.getUriResolver(configuration, file);
            String styleSheet = this.getStyleSheet(configuration.getModelType(), file);
            URL xsl = ClassLoaders.getURL((String)styleSheet);
            String newExtension = configuration.getModelType();
            File mirrorFile = GeneratorUtil.getRelativeFile((File)inputDirectory, (File)outputDirectory, (File)file);
            File result = GeneratorUtil.changeExtension((File)mirrorFile, (String)newExtension);
            if (!configuration.isOverwrite() && file.lastModified() < result.lastModified()) {
                if (configuration.isVerbose()) {
                    this.getLog().info((CharSequence)String.format("Will not generate %s (up-to-date).", result));
                }
                return false;
            }
            PluginHelper.createDirectoryIfNecessary((File)result.getParentFile());
            WriterReport writerReport = this.getWriterReport();
            if (writerReport != null) {
                writerReport.addFile(((Object)((Object)this)).getClass().getName(), result, false);
            }
            Transformer transformer = this.getTransformerFactory().newTransformer(new StreamSource(xsl.openStream()));
            transformer.setParameter(PROP_FULL_PACKAGE_PATH, this.getFullPackagePath());
            transformer.setParameter(PROP_EXTRACTED_PACKAGES, this.getExtractedPackages());
            transformer.setURIResolver(fileResolver);
            try (FileOutputStream output = new FileOutputStream(result);){
                transformer.transform(new StreamSource(file), new StreamResult(output));
            }
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected URIResolver getUriResolver(ChainedFileWriterConfiguration configuration, File model) {
        URIResolver result = null;
        try {
            ClassLoader loader = configuration.getClassLoader();
            Class<?> clazz = Class.forName(this.getResolver(), true, loader);
            try {
                Constructor<?> withBaseConstructor = clazz.getConstructor(String.class);
                String base = model.getParentFile().getAbsolutePath();
                result = (URIResolver)withBaseConstructor.newInstance(base);
            }
            catch (Exception eee) {
                this.getLog().warn((CharSequence)"Unable to instantiate resolver with String parameter", (Throwable)eee);
            }
            if (result == null) {
                result = (URIResolver)clazz.newInstance();
            }
            if (result instanceof ResourceResolver) {
                ((ResourceResolver)result).setVerbose(configuration.isVerbose());
                ((ResourceResolver)result).setCl(loader);
                if (result instanceof FasterCachedResourceResolver) {
                    boolean offline = configuration.isOffline();
                    this.getLog().debug((CharSequence)("using offline mode  ? : " + offline));
                    ((FasterCachedResourceResolver)result).setOffline(offline);
                }
            }
        }
        catch (Exception eee) {
            this.getLog().warn((CharSequence)"Unable to instantiate resolver using the default constructor", (Throwable)eee);
        }
        return result;
    }

    protected String getStyleSheet(String modelType, File model) {
        if ("objectmodel".equals(modelType)) {
            String version = this.getXmiVersion(model);
            String styleSheet = null;
            if (version.startsWith("1.")) {
                styleSheet = "xmi1.2ToObjectModel.xsl";
            } else if (version.startsWith("2.")) {
                styleSheet = "xmi2.1ToObjectModel.xsl";
            } else {
                this.getLog().error((CharSequence)("Unsupported xmi version [" + version + "]"));
            }
            return styleSheet;
        }
        if ("statemodel".equals(modelType)) {
            return "xmi1.2ToStateModel.xsl";
        }
        throw new IllegalStateException("unsupported modelType [" + modelType + "]");
    }

    protected String getXmiVersion(File xmiFile) {
        String version = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XmiVersionHandler handler = new XmiVersionHandler();
            parser.parse(xmiFile, (DefaultHandler)handler);
            version = handler.getVersion();
        }
        catch (ParserConfigurationException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        catch (SAXException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        return version;
    }

    protected class XmiVersionHandler
    extends DefaultHandler {
        protected String version;

        public String getVersion() {
            return this.version;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("XMI")) {
                this.version = attributes.getValue("xmi.version");
                if (XmiChainedFileWriter.this.getLog().isDebugEnabled()) {
                    XmiChainedFileWriter.this.getLog().debug((CharSequence)("XMI version found : " + this.version));
                }
            }
            if (this.version == null) {
                this.version = attributes.getValue("xmi:version");
                if (XmiChainedFileWriter.this.getLog().isDebugEnabled()) {
                    XmiChainedFileWriter.this.getLog().debug((CharSequence)("XMI version found : " + this.version));
                }
            }
        }
    }
}

