/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.extension.io.ModelExtensionReader;
import org.nuiton.eugene.models.extension.tagvalue.InvalidStereotypeSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.InvalidTagValueSyntaxException;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterToMemoryModel;

public abstract class BaseChainedFileWriterToMemoryModel
extends BaseChainedFileWriter
implements ChainedFileWriterToMemoryModel {
    public static final String PROP_MODEL_READER = "modelReader";
    public static final String PROP_FAIL_IF_UNSAFE = "failIfUnsafe";
    public static final String PROP_READER = "reader";
    protected Model model;
    protected File lastModifiedFile;
    protected File outputDirectory;

    public BaseChainedFileWriterToMemoryModel() {
        super(PROP_READER, PROP_READER, PROP_MODEL_READER, "xmlModelReader", PROP_FAIL_IF_UNSAFE, PROP_FAIL_IF_UNSAFE);
    }

    public Model getModel() {
        return this.model;
    }

    public long getLastModifiedSource() {
        return this.lastModifiedFile == null ? 0L : this.lastModifiedFile.lastModified();
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getOutputProtocol(String modelType) {
        return null;
    }

    public boolean acceptModel(String modelType) {
        return this.acceptObjectModelOrStateModel(modelType);
    }

    protected abstract String getInputType();

    protected ModelReader<?> getModelReader() {
        return (ModelReader)this.getProperty(PROP_MODEL_READER, ModelReader.class);
    }

    protected String getReader() {
        return (String)this.getProperty(PROP_READER, String.class);
    }

    protected boolean isFailIfUnsafe() {
        Boolean property = (Boolean)this.getProperty(PROP_FAIL_IF_UNSAFE, Boolean.class);
        return property != null && property != false;
    }

    @Override
    protected void initWriter(ChainedFileWriterConfiguration configuration) {
        ClassLoader classLoader;
        super.initWriter(configuration);
        ClassLoader loader = classLoader = configuration.getClassLoader();
        if (this.getModelReader() == null) {
            ModelReader modelReader;
            block7: {
                String modelType = configuration.getModelType();
                if (this.getReader() != null) {
                    String reader = this.getReader();
                    try {
                        ClassLoader fixedClassLoader = loader;
                        modelReader = (ModelReader)Class.forName(reader, true, fixedClassLoader).newInstance();
                        String modelTypeFromReader = modelReader.getModelType();
                        if (!modelType.equals(modelTypeFromReader)) {
                            throw new IllegalStateException("Model reader [" + modelTypeFromReader + "] does not match with modelType: " + modelType);
                        }
                        break block7;
                    }
                    catch (IllegalStateException eee) {
                        throw eee;
                    }
                    catch (Exception eee) {
                        throw new IllegalStateException("could not obtain reader " + reader, eee);
                    }
                }
                String inputType = this.getInputType();
                modelReader = configuration.getModelHelper().getModelReader(modelType, inputType);
                if (modelReader == null) {
                    throw new IllegalStateException("could not find a model reader for modelType: " + modelType + ", and input type: " + inputType + ", availables readers : " + configuration.getModelHelper().getModelReaders().values());
                }
            }
            modelReader.setStrictLoading(this.isFailIfUnsafe());
            this.properties.put(PROP_MODEL_READER, modelReader);
        }
        boolean verbose = configuration.isVerbose();
        this.getModelReader().setVerbose(verbose);
    }

    public void generate(ChainedFileWriterConfiguration configuration, File outputDir, Map<File, List<File>> filesByRoot, Map<File, List<File>> resourcesByFile) throws IOException {
        HashSet<File> modelFiles = new HashSet<File>();
        for (List<File> files : filesByRoot.values()) {
            modelFiles.addAll(files);
            this.setLastModifiedSource(files);
        }
        for (List<File> files : resourcesByFile.values()) {
            this.setLastModifiedSource(files);
        }
        LinkedList<File> sortedModelFiles = new LinkedList<File>(modelFiles);
        sortedModelFiles.sort(Comparator.comparing(File::getName));
        File[] filesToRead = sortedModelFiles.toArray(new File[0]);
        if (configuration.isVerbose()) {
            this.getLog().info((CharSequence)("Will read " + filesToRead.length + " model(s)."));
        }
        this.model = this.getModelReader().read(filesToRead);
        if (this.model instanceof ObjectModel && configuration.getModelExtensionFile() != null) {
            ModelExtensionReader modelExtensionReader = new ModelExtensionReader(configuration.isVerbose(), this.isFailIfUnsafe(), (ObjectModel)this.model);
            try {
                modelExtensionReader.read(configuration.getModelExtensionFile());
            }
            catch (InvalidStereotypeSyntaxException | InvalidTagValueSyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        if (configuration.isVerbose()) {
            this.getLog().info((CharSequence)("Last modified file: " + this.lastModifiedFile + " - " + new Date(this.getLastModifiedSource())));
        }
        this.outputDirectory = outputDir;
    }

    protected void setLastModifiedSource(Iterable<File> files) {
        for (File file : files) {
            if (file.lastModified() <= this.getLastModifiedSource()) continue;
            this.lastModifiedFile = file;
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("New lastModifiedFile date: " + this.lastModifiedFile + " : " + this.getLastModifiedSource()));
        }
    }
}

