/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import io.ultreia.java4all.i18n.I18n;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.writer.ChainedFileWriter;

@Mojo(name="available-data", requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST)
public class AvailableDataMojo
extends AbstractMojo {
    @Parameter(property="dataTypes")
    protected String dataTypes;
    @Component(role=Model.class)
    protected Map<String, Model> modelTypes;
    @Component(role=ModelReader.class)
    protected Map<String, ModelReader<?>> modelReaders;
    @Component(role=Template.class)
    protected Map<String, Template<?>> modelTemplates;
    @Component(role=ChainedFileWriter.class)
    protected Map<String, ChainedFileWriter> writers;
    @Component(role=TagValueMetadatasProvider.class)
    protected Map<String, TagValueMetadatasProvider> tagValueMetadatasProviders;
    protected TagValueMetadatasProvider currentTagValueMetadatasProvider;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EnumSet<AvailableData> safeDataTypes;
        StringBuilder buffer = new StringBuilder();
        String string = this.dataTypes = this.dataTypes == null ? "" : this.dataTypes.trim();
        if (StringUtils.isEmpty((CharSequence)this.dataTypes)) {
            safeDataTypes = EnumSet.allOf(AvailableData.class);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("will use all data types : " + safeDataTypes));
            }
        } else {
            safeDataTypes = EnumSet.noneOf(AvailableData.class);
            for (String string2 : this.dataTypes.split(",")) {
                String string3 = string2.trim().toLowerCase();
                try {
                    AvailableData data = AvailableData.valueOf(string3);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("will use data type " + (Object)((Object)data)));
                    }
                    safeDataTypes.add(data);
                }
                catch (IllegalArgumentException e) {
                    this.getLog().warn((CharSequence)("does not know data type : " + string3 + " use one of " + Arrays.toString((Object[])AvailableData.values())));
                }
            }
        }
        for (AvailableData data : safeDataTypes) {
            buffer.append("\n");
            this.appendData(data, buffer);
        }
        this.getLog().info((CharSequence)("Get datas for data types : " + safeDataTypes + buffer.toString()));
    }

    protected void appendData(AvailableData data, StringBuilder buffer) {
        String dataType = data.name();
        if (data == AvailableData.tagvalue) {
            int nbData = 0;
            Iterator<TagValueMetadatasProvider> iterator = this.tagValueMetadatasProviders.values().iterator();
            while (iterator.hasNext()) {
                TagValueMetadatasProvider provider;
                this.currentTagValueMetadatasProvider = provider = iterator.next();
                nbData += data.getData(this).size();
            }
            this.currentTagValueMetadatasProvider = null;
            String format = "\nFound %s %ss in %s provider(s) : %s\n";
            buffer.append(String.format(format, nbData, dataType, this.tagValueMetadatasProviders.size(), this.tagValueMetadatasProviders.keySet()));
            for (Map.Entry<String, TagValueMetadatasProvider> e : this.tagValueMetadatasProviders.entrySet()) {
                String providerName = e.getKey();
                this.currentTagValueMetadatasProvider = e.getValue();
                Map<String, ?> map = data.getData(this);
                int size = map.size();
                buffer.append("\nProvider [").append(providerName).append("] - ");
                if (size == 0) {
                    buffer.append("No available ").append(dataType).append(".");
                } else if (size == 1) {
                    buffer.append("Found one ").append(dataType).append(" : ");
                } else {
                    buffer.append("Found ");
                    buffer.append(size);
                    buffer.append(" ");
                    buffer.append(dataType);
                    buffer.append("s : ");
                }
                for (Map.Entry<String, ?> e2 : map.entrySet()) {
                    data.toString(buffer, e2);
                }
            }
        } else {
            int size;
            Map<String, ?> map = data.getData(this);
            int n = size = map == null ? 0 : map.size();
            if (size == 0) {
                buffer.append("\nNo available ").append(dataType).append(".");
            } else {
                if (size == 1) {
                    buffer.append("\nFound one ").append(dataType).append(" : ");
                } else {
                    buffer.append("\nFound ");
                    buffer.append(size);
                    buffer.append(" ");
                    buffer.append(dataType);
                    buffer.append("s : ");
                }
                for (Map.Entry<String, ?> e : map.entrySet()) {
                    data.toString(buffer, e);
                }
            }
        }
    }

    static enum AvailableData {
        modeltype{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTypes;
            }
        }
        ,
        writer{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.writers;
            }

            @Override
            String toString(Object data) {
                ChainedFileWriter w = (ChainedFileWriter)data;
                String b = super.toString(data) + "\n  inputProtocol             : " + w.getInputProtocol() + "\n  outputProtocol            : " + w.getOutputProtocol("objectmodel") + "\n  defaultIncludes           : " + w.getDefaultIncludes() + "\n  defaultInputDirectory     : " + w.getDefaultInputDirectory() + "\n  defaultTestInputDirectory : " + w.getDefaultTestInputDirectory();
                return b;
            }
        }
        ,
        modelreader{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelReaders;
            }
        }
        ,
        modeltemplate{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTemplates;
            }
        }
        ,
        tagvalue{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                Set tagValues = mojo.currentTagValueMetadatasProvider.getTagValues();
                return Maps.uniqueIndex((Iterable)tagValues, (Function)new Function<TagValueMetadata, String>(){

                    public String apply(TagValueMetadata input) {
                        return input.getName();
                    }
                });
            }

            @Override
            String toString(Object data) {
                TagValueMetadata d = (TagValueMetadata)data;
                StringBuilder sb = new StringBuilder();
                Set targets = d.getTargets();
                for (Class aClass : targets) {
                    sb.append(", ").append(aClass.getSimpleName());
                }
                String result = sb.toString();
                if (targets.size() > 0) {
                    result = result.substring(2);
                }
                return result;
            }

            @Override
            void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
                String name = e.getKey();
                Object value = e.getValue();
                buffer.append("\n [");
                buffer.append(name);
                buffer.append("] targets : '");
                buffer.append(this.toString(value));
                buffer.append("' : ");
                buffer.append(I18n.t((String)((TagValueMetadata)value).getDescription(), (Object[])new Object[0]));
            }
        };


        abstract Map<String, ?> getData(AvailableDataMojo var1);

        String toString(Object data) {
            return data.getClass().getName();
        }

        void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
            String name = e.getKey();
            Object value = e.getValue();
            buffer.append("\n [");
            buffer.append(name);
            buffer.append("] with implementation '");
            buffer.append(this.toString(value));
            buffer.append('\'');
        }
    }
}

