/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.context;

import io.ultreia.java4all.application.context.ApplicationComponentValueSupplier;
import io.ultreia.java4all.application.context.spi.ApplicationComponentInstantiateStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationComponent<O>
implements Supplier<O>,
Closeable {
    private static final Logger log = LogManager.getLogger(ApplicationComponent.class);
    private final String name;
    private final Class<O> componentType;
    private final List<Class<?>> dependencies;
    private final List<Class<?>> hints;
    private final ApplicationComponentValueSupplier<O> supplier;

    protected ApplicationComponent(String name, Class<O> componentType, boolean requireNotNull, ApplicationComponentInstantiateStrategy instantiateStrategy, Class<?>[] hints, Class<?>[] dependencies) {
        this(name, componentType, requireNotNull, instantiateStrategy, hints, dependencies, ApplicationComponentValueSupplier.create(componentType, requireNotNull, instantiateStrategy, dependencies));
    }

    protected ApplicationComponent(String name, Class<O> componentType, boolean requireNotNull, ApplicationComponentInstantiateStrategy instantiateStrategy, Class<?>[] hints, Class<?>[] dependencies, ApplicationComponentValueSupplier<O> supplier) {
        this.name = name;
        this.componentType = componentType;
        this.dependencies = new LinkedList();
        Collections.addAll(this.dependencies, dependencies);
        this.hints = new LinkedList();
        Collections.addAll(this.hints, hints);
        this.supplier = supplier;
    }

    @Override
    public O get() {
        return this.supplier.get();
    }

    public String getName() {
        return this.name;
    }

    public Class<O> getComponentType() {
        return this.componentType;
    }

    public void setValue(O value) {
        this.supplier.setSupplier(() -> value);
    }

    @Override
    public void close() throws IOException {
        log.info("Closing component: " + this);
        if (this.supplier.withValue()) {
            if (Closeable.class.isAssignableFrom(this.componentType)) {
                ((Closeable)this.supplier.get()).close();
            }
            this.supplier.clear();
        }
    }

    public boolean withDependencies() {
        return !this.getDependencies().isEmpty();
    }

    public List<Class<?>> getDependencies() {
        return this.dependencies;
    }

    public void addExtraHints(Class<?> ... hints) {
        Collections.addAll(this.hints, hints);
    }

    public List<Class<?>> getHints() {
        return this.hints;
    }

    public String toString() {
        return String.format("%s \u2192 %s", this.name, this.componentType.getName());
    }
}

