package io.typeflows.gradle.tasks

import org.gradle.api.file.DirectoryProperty
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.TaskAction
import java.io.File

abstract class InstallClaudeTask : InstallTask() {
    @get:OutputDirectory
    abstract val claudeDirectory: DirectoryProperty

    @TaskAction
    fun typeflowsInstallClaude() {
        executeInstall()
    }

    override fun getTargetDirectory() = claudeDirectory

    override fun processExtractedFiles(outputDir: File) {
    }

    override fun logSuccess(outputDir: File) {
        logger.lifecycle(
            "${GREEN}✅ Claude commands installed:${RESET} ${CYAN}${outputDir.relativeTo(project.rootDir)}${RESET}"
        )
    }
}
